/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.db.managers;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBSession;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBUtils;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.ServiceUtils;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Analysis;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.SubmittedStatus;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.fields.AnalysisFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.AnalysisType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.FieldType;
import org.gcube_system.namespaces.application.aquamaps.types.OrderDirection;
import org.gcube_system.namespaces.application.aquamaps.types.PagedRequestSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalysisTableManager {
    static final Logger logger = LoggerFactory.getLogger(AnalysisTableManager.class);
    private static final String analysisTable = "analysis_table";

    public String getJSONRequests(List<Field> filters, PagedRequestSettings settings) throws Exception {
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            String string = DBUtils.toJSon(session.executeFilteredQuery(filters, analysisTable, settings.getOrderField(), settings.getOrderDirection()), settings.getOffset(), settings.getOffset() + settings.getLimit());
            return string;
        }
    }

    public static String insertRequest(Analysis toInsert) throws Exception {
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            toInsert.setId(ServiceUtils.generateId("An", ""));
            toInsert.setStatus(SubmittedStatus.Pending);
            toInsert.setSubmissiontime(Long.valueOf(System.currentTimeMillis()));
            ArrayList<List<Field>> rows = new ArrayList<List<Field>>();
            ArrayList<Field> toInsertRow = new ArrayList<Field>();
            logger.debug("Inserting request, fields are :");
            for (Field f : toInsert.toRow()) {
                if (f.value() == null || f.value().equalsIgnoreCase("null")) continue;
                toInsertRow.add(f);
                logger.debug(f.toXML());
            }
            rows.add(toInsertRow);
            session.insertOperation(analysisTable, rows);
            String string = toInsert.getId();
            return string;
        }
    }

    private static void updateField(String id, List<Field> values) throws Exception {
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            ArrayList<List<Field>> keys = new ArrayList<List<Field>>();
            ArrayList<Field> key = new ArrayList<Field>();
            key.add(new Field("" + AnalysisFields.id, id, FieldType.STRING));
            keys.add(key);
            ArrayList<List<Field>> rows = new ArrayList<List<Field>>();
            rows.add(values);
            session.updateOperation(analysisTable, keys, rows);
        }
    }

    public static ArrayList<Analysis> getList(ArrayList<Field> filter) throws Exception {
        DBSession session = null;
        if (filter == null) {
            filter = new ArrayList();
        }
        try {
            session = DBSession.getInternalDBSession();
            ArrayList arrayList = Analysis.loadResultSet((ResultSet)session.executeFilteredQuery(filter, analysisTable, "" + AnalysisFields.submissiontime, OrderDirection.ASC));
            return arrayList;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static List<Analysis> getList(List<Field> filter, PagedRequestSettings settings) throws Exception {
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            ArrayList<Analysis> toReturn = new ArrayList<Analysis>();
            ResultSet rs = session.executeFilteredQuery(filter, analysisTable, settings.getOrderField(), settings.getOrderDirection());
            int rowIndex = 0;
            while (rs.next() && toReturn.size() < settings.getLimit()) {
                if (rowIndex >= settings.getOffset()) {
                    toReturn.add(new Analysis(rs));
                }
                ++rowIndex;
            }
            ArrayList<Analysis> arrayList = toReturn;
            return arrayList;
        }
    }

    public static void addReportId(int reportId, String id) throws Exception {
        Analysis req = AnalysisTableManager.getById(id);
        req.addReportId(Integer.valueOf(reportId));
        AnalysisTableManager.updateField(id, new ArrayList<Field>(Arrays.asList(req.getField(AnalysisFields.reportid))));
    }

    public static void addCompletedAnalysis(String id, AnalysisType toAdd) throws Exception {
        Analysis req = AnalysisTableManager.getById(id);
        req.getPerformedAnalysis().add(toAdd);
        AnalysisTableManager.updateField(id, new ArrayList<Field>(Arrays.asList(req.getField(AnalysisFields.performedanalysis))));
    }

    public static void removeReportId(int reportId, String id) throws Exception {
        Analysis req = AnalysisTableManager.getById(id);
        req.removeReportId(Integer.valueOf(reportId));
        AnalysisTableManager.updateField(id, new ArrayList<Field>(Arrays.asList(req.getField(AnalysisFields.reportid))));
    }

    public static void setPhasePercent(double percent, String id) throws Exception {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("" + AnalysisFields.currentphasepercent, String.valueOf(percent), FieldType.DOUBLE));
        AnalysisTableManager.updateField(id, fields);
    }

    public static void setStartTime(String id) throws Exception {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("" + AnalysisFields.starttime, String.valueOf(System.currentTimeMillis()), FieldType.LONG));
        AnalysisTableManager.updateField(id, fields);
    }

    public static void setArchivePath(String id, String path) throws Exception {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("" + AnalysisFields.archivelocation, path, FieldType.STRING));
        AnalysisTableManager.updateField(id, fields);
    }

    public static void setStatus(SubmittedStatus status, String id) throws Exception {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("" + AnalysisFields.status, "" + status, FieldType.STRING));
        if (status.equals((Object)SubmittedStatus.Completed) || status.equals((Object)SubmittedStatus.Error)) {
            fields.add(new Field("" + AnalysisFields.endtime, String.valueOf(System.currentTimeMillis()), FieldType.LONG));
            fields.add(new Field("" + AnalysisFields.currentphasepercent, "100", FieldType.DOUBLE));
        }
        AnalysisTableManager.updateField(id, fields);
    }

    public static String getJSONList(List<Field> filters, PagedRequestSettings settings) throws Exception {
        if (filters == null) {
            filters = new ArrayList<Field>();
        }
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            String string = DBUtils.toJSon(session.executeFilteredQuery(filters, analysisTable, settings.getOrderField(), settings.getOrderDirection()), settings.getOffset(), settings.getOffset() + settings.getOffset() + settings.getLimit());
            return string;
        }
    }

    public static int delete(ArrayList<Field> filter) throws Exception {
        DBSession session = null;
        if (filter == null) {
            filter = new ArrayList();
        }
        try {
            session = DBSession.getInternalDBSession();
            PreparedStatement ps = session.getPreparedStatementForDelete(filter, analysisTable);
            int n = session.fillParameters(filter, 0, ps).executeUpdate();
            return n;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static Analysis getById(String id) throws Exception {
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            ArrayList<Field> filters = new ArrayList<Field>();
            filters.add(new Field("" + AnalysisFields.id, String.valueOf(id), FieldType.STRING));
            Analysis analysis = AnalysisTableManager.loadRS(session.executeFilteredQuery(filters, analysisTable, "" + AnalysisFields.id, OrderDirection.ASC)).iterator().next();
            return analysis;
        }
    }

    public static int delete(String id) throws Exception {
        ArrayList<Field> filter = new ArrayList<Field>();
        filter.add(new Field("" + AnalysisFields.id, id, FieldType.STRING));
        return AnalysisTableManager.delete(filter);
    }

    public static Long getCount(List<Field> filter) throws Exception {
        DBSession session = null;
        if (filter == null) {
            filter = new ArrayList<Field>();
        }
        try {
            session = DBSession.getInternalDBSession();
            Long l = session.getCount(analysisTable, filter);
            return l;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private static Set<Analysis> loadRS(ResultSet rs) throws Exception {
        HashSet<Analysis> toReturn = new HashSet<Analysis>();
        while (rs.next()) {
            toReturn.add(new Analysis(rs));
        }
        return toReturn;
    }
}

