/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.db.managers;

import java.io.File;
import java.io.FileWriter;
import java.io.ObjectOutputStream;
import java.io.Writer;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.impl.ServiceContext;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBSession;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.ServiceUtils;
import org.gcube.application.aquamaps.aquamapsservice.stubs.BulkStatus;
import org.gcube.application.aquamaps.aquamapsservice.stubs.GetBulkUpdatesStatusResponseType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.BulkItem;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.ItemResources;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.xstream.AquaMapsXStream;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.fields.SpeciesOccursumFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.FieldType;
import org.gcube.application.aquamaps.publisher.Publisher;
import org.gcube.application.aquamaps.publisher.impl.model.FileSet;
import org.gcube.application.aquamaps.publisher.impl.model.Layer;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube_system.namespaces.application.aquamaps.types.OrderDirection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkReportsManager {
    static final Logger logger = LoggerFactory.getLogger(BulkReportsManager.class);
    private static final String tablename = "bulkrequests";
    private static final String remoteFileField = "remoteid";
    private static final String scopeField = "scope";
    private static final String includeGisField = "includegis";
    private static final String includeCustomField = "includecustom";
    private static final String lowerintervalField = "lowerinterval";
    private static final String searchidField = "searchid";
    private static final String statusField = "status";
    private static final String submissionTimeField = "submissionTime";

    static {
        new BulkMonitorThread().start();
    }

    public static String insertRequest(Long lowerInterval, boolean includeGis, boolean includeCustom) throws Exception {
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            ArrayList<Field> toAdd = new ArrayList<Field>();
            String id = ServiceUtils.generateId("B", "");
            toAdd.add(new Field(searchidField, id, FieldType.STRING));
            toAdd.add(new Field(scopeField, ServiceContext.getContext().getScope().toString()));
            toAdd.add(new Field(includeGisField, String.valueOf(includeGis), FieldType.BOOLEAN));
            toAdd.add(new Field(includeCustomField, String.valueOf(includeCustom), FieldType.BOOLEAN));
            toAdd.add(new Field(lowerintervalField, "" + lowerInterval, FieldType.LONG));
            toAdd.add(new Field(statusField, "" + org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.BulkStatus.PENDING, FieldType.STRING));
            toAdd.add(new Field(submissionTimeField, String.valueOf(System.currentTimeMillis()), FieldType.LONG));
            ArrayList<List<Field>> rows = new ArrayList<List<Field>>();
            rows.add(toAdd);
            session.insertOperation(tablename, rows);
            String string = id;
            return string;
        }
    }

    public static GetBulkUpdatesStatusResponseType getStatus(String id) throws Exception {
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            ArrayList<Field> filter = new ArrayList<Field>();
            filter.add(new Field(searchidField, id, FieldType.STRING));
            ResultSet rs = session.executeFilteredQuery(filter, tablename, searchidField, OrderDirection.ASC);
            if (rs.next()) {
                GetBulkUpdatesStatusResponseType getBulkUpdatesStatusResponseType = new GetBulkUpdatesStatusResponseType(rs.getString(remoteFileField), BulkStatus.fromString((String)rs.getString(statusField)));
                return getBulkUpdatesStatusResponseType;
            }
            throw new Exception("Bulk request with id " + id + " not found");
        }
    }

    public static List<Field> getFirstPending() throws Exception {
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            ArrayList<Field> filter = new ArrayList<Field>();
            filter.add(new Field(statusField, "" + org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.BulkStatus.PENDING, FieldType.STRING));
            ResultSet rs = session.executeFilteredQuery(filter, tablename, submissionTimeField, OrderDirection.ASC);
            if (rs.next()) {
                List list = Field.loadRow((ResultSet)rs);
                return list;
            }
            return null;
        }
    }

    public static void update(String id, org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.BulkStatus status, String remoteId) throws Exception {
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            ArrayList<Field> key = new ArrayList<Field>();
            key.add(new Field(searchidField, id, FieldType.STRING));
            ArrayList<List<Field>> keys = new ArrayList<List<Field>>();
            keys.add(key);
            ArrayList<Field> toSetValue = new ArrayList<Field>();
            toSetValue.add(new Field(statusField, "" + status, FieldType.STRING));
            toSetValue.add(new Field(remoteFileField, remoteId, FieldType.STRING));
            ArrayList<List<Field>> rows = new ArrayList<List<Field>>();
            rows.add(toSetValue);
            session.updateOperation(tablename, keys, rows);
        }
    }

    public static String prepareBulk(Long updateInterval, String scope, boolean includeGIS, boolean includeCustom) throws Exception {
        logger.debug("Preparing bulk updates from time " + ServiceUtils.formatTimeStamp(updateInterval));
        DBSession session = null;
        Publisher pub = ServiceContext.getContext().getPublisher();
        String publisherHost = ServiceContext.getContext().getPublisher().getWebServerUrl();
        File local = File.createTempFile("bulk", ".xml");
        AquaMapsXStream xstream = AquaMapsXStream.getXMLInstance();
        ObjectOutputStream oos = xstream.createObjectOutputStream((Writer)new FileWriter(local));
        try {
            long count = 0L;
            long speciesCount = 0L;
            session = DBSession.getInternalDBSession();
            ResultSet rsSpecies = session.executeQuery("Select " + SpeciesOccursumFields.speciesid + "," + SpeciesOccursumFields.genus + "," + SpeciesOccursumFields.species + " from speciesoccursum");
            logger.debug("Got Species list, gonna check maps..");
            while (rsSpecies.next()) {
                String speciesId = rsSpecies.getString(1);
                String scientificName = String.valueOf(rsSpecies.getString(2)) + "_" + rsSpecies.getString(3);
                BulkItem item = new BulkItem();
                item.setSpeciesId(speciesId);
                try {
                    List fileSets = pub.getFileSetsBySpeciesIds(scientificName);
                    for (FileSet fs : fileSets) {
                        try {
                            if (includeCustom && (!includeCustom || !fs.isCustomized()) || fs.getMetaInfo().getDataGenerationTime() < updateInterval) continue;
                            Integer hspecId = Integer.parseInt(fs.getTableId());
                            if (!item.getResources().containsKey(hspecId)) {
                                item.getResources().put(hspecId, new ItemResources());
                            }
                            String uri = null;
                            for (org.gcube.application.aquamaps.publisher.impl.model.File f : fs.getFiles()) {
                                if (uri != null && !f.getName().equals("Earth")) continue;
                                uri = String.valueOf(publisherHost) + f.getStoredUri();
                            }
                            ((ItemResources)item.getResources().get(hspecId)).addResource(false, fs.isCustomized(), uri);
                        }
                        catch (Throwable t) {
                            logger.debug("Unable to check fs " + fs.getId(), t);
                        }
                    }
                    if (includeGIS) {
                        List foundLayers = pub.getLayersBySpeciesIds(scientificName);
                        for (Layer l : foundLayers) {
                            try {
                                if (includeCustom && (!includeCustom || !l.isCustomized()) || l.getMetaInfo().getDataGenerationTime() < updateInterval) continue;
                                Integer hspecId = Integer.parseInt(l.getTableId());
                                if (!item.getResources().containsKey(hspecId)) {
                                    item.getResources().put(hspecId, new ItemResources());
                                }
                                ((ItemResources)item.getResources().get(hspecId)).addResource(true, l.isCustomized(), l.getId());
                            }
                            catch (Throwable t) {
                                logger.debug("Unable to check layer " + l.getId(), t);
                            }
                        }
                    }
                    if (item.hasResources()) {
                        oos.writeObject(item);
                        ++count;
                    }
                    ++speciesCount;
                }
                catch (Exception e) {
                    logger.error("Unable to gather information for species " + speciesId, (Throwable)e);
                }
            }
            oos.flush();
            oos.close();
            oos = null;
            logger.debug("Serialized " + count + " bulk itmes out of " + speciesCount + " species into local file " + local.getAbsolutePath());
            ScopeProvider.instance.set(scope);
            IClient client = new StorageClient("Application", "AquaMapsService", "AquaMapsService", AccessType.SHARED, MemoryType.VOLATILE).getClient();
            String remoteId = client.put(true).LFile(local.getAbsolutePath()).RFile("/img/" + local.getName());
            logger.debug("Created remote file " + remoteId);
            String string = remoteId;
            return string;
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (oos != null) {
                oos.close();
            }
        }
    }

    public static class BulkMonitorThread
    extends Thread {
        public BulkMonitorThread() {
            this.setName("BulkMonitorThread");
        }

        @Override
        public void run() {
            while (true) {
                try {
                    try {
                        String scope = null;
                        Long lowerInterval = null;
                        String id = null;
                        boolean includeGIS = false;
                        boolean includeCustom = false;
                        List<Field> pending = BulkReportsManager.getFirstPending();
                        if (pending == null) continue;
                        logger.debug("found pending bulk request.. " + pending);
                        for (Field f : pending) {
                            if (f.name().equalsIgnoreCase(BulkReportsManager.includeCustomField)) {
                                includeCustom = f.getValueAsBoolean();
                                continue;
                            }
                            if (f.name().equalsIgnoreCase(BulkReportsManager.includeGisField)) {
                                includeGIS = f.getValueAsBoolean();
                                continue;
                            }
                            if (f.name().equalsIgnoreCase(BulkReportsManager.scopeField)) {
                                scope = f.value();
                                continue;
                            }
                            if (f.name().equalsIgnoreCase(BulkReportsManager.lowerintervalField)) {
                                lowerInterval = f.getValueAsLong();
                                continue;
                            }
                            if (!f.name().equalsIgnoreCase(BulkReportsManager.searchidField)) continue;
                            id = f.value();
                        }
                        BulkReportsManager.update(id, org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.BulkStatus.ONGOING, "");
                        try {
                            String remoteId = BulkReportsManager.prepareBulk(lowerInterval, scope, includeGIS, includeCustom);
                            BulkReportsManager.update(id, org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.BulkStatus.COMPLETED, remoteId);
                        }
                        catch (Exception e) {
                            logger.error("Unable to prepare bulk ", (Throwable)e);
                            BulkReportsManager.update(id, org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.BulkStatus.ERROR, "");
                        }
                    }
                    catch (Exception e) {
                        logger.error("Unexpected Exception", (Throwable)e);
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    continue;
                }
                finally {
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        }
    }
}

