/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsspeciesview.servlet;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.gcube.application.aquamaps.aquamapsservice.client.plugins.AbstractPlugin;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.DataManagement;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.Maps;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.Publisher;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.AquaMap;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.AquaMapsObject;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Filter;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Resource;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Species;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.xstream.AquaMapsXStream;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.fields.SpeciesOccursumFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.PagedRequestSettings;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.FieldType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.FilterType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.OrderDirection;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.ResourceType;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.AquaMapsSpeciesViewLocalService;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.EnumSerializationForcer;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.data.ClientResource;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.data.CompoundMapItem;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.data.Response;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.data.SettingsDescriptor;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.data.SpeciesFilter;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.data.SpeciesSearchDescriptor;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.data.save.SaveOperationProgress;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.data.save.SaveRequest;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.types.ClientResourceType;
import org.gcube.application.aquamaps.aquamapsspeciesview.servlet.db.DBManager;
import org.gcube.application.aquamaps.aquamapsspeciesview.servlet.save.SaveManager;
import org.gcube.application.aquamaps.aquamapsspeciesview.servlet.utils.ModelTranslation;
import org.gcube.application.aquamaps.aquamapsspeciesview.servlet.utils.Utils;
import org.gcube.application.framework.core.session.ASLSession;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AquaMapsSpeciesViewLocalServiceImpl
extends RemoteServiceServlet
implements AquaMapsSpeciesViewLocalService {
    private static final long serialVersionUID = -2337999405162440998L;
    private static final Logger logger = LoggerFactory.getLogger(AquaMapsSpeciesViewLocalServiceImpl.class);
    private static final String layersPath = File.separator + "config" + File.separator + "layers.xml";

    public Response setGenericSearchFilter(String searchValue) throws Exception {
        logger.debug("SetGenericSearchFilter " + searchValue);
        try {
            ASLSession session = Utils.getSession((HttpSession)this.getThreadLocalRequest().getSession());
            SpeciesSearchDescriptor descriptor = (SpeciesSearchDescriptor)session.getAttribute("SPECIES_SEARCH_FILTER");
            descriptor.setGenericSearchFieldValue(searchValue != null && !searchValue.isEmpty() ? searchValue : null);
            session.setAttribute("SPECIES_SEARCH_FILTER", (Object)descriptor);
            return new Response(Boolean.valueOf(true));
        }
        catch (Exception e) {
            logger.error("Set generic search filter : " + searchValue, (Throwable)e);
            return new Response(Boolean.valueOf(false));
        }
    }

    public SpeciesSearchDescriptor getFilterSettings() throws Exception {
        logger.debug("GetFilterSettings");
        try {
            ASLSession session = Utils.getSession((HttpSession)this.getThreadLocalRequest().getSession());
            SpeciesSearchDescriptor descriptor = (SpeciesSearchDescriptor)session.getAttribute("SPECIES_SEARCH_FILTER");
            return descriptor;
        }
        catch (Exception e) {
            logger.error("get filter settings ", (Throwable)e);
            throw new Exception("Session might be expired");
        }
    }

    public Response setAdvancedSpeciesFilter(List<SpeciesFilter> updatedList) throws Exception {
        try {
            ASLSession session = Utils.getSession((HttpSession)this.getThreadLocalRequest().getSession());
            SpeciesSearchDescriptor descriptor = (SpeciesSearchDescriptor)session.getAttribute("SPECIES_SEARCH_FILTER");
            descriptor.getAdvancedFilterList().clear();
            descriptor.getAdvancedFilterList().addAll(updatedList);
            return new Response(Boolean.valueOf(true));
        }
        catch (Exception e) {
            logger.error("Set advanced Species filter ", (Throwable)e);
            return new Response(Boolean.valueOf(false));
        }
    }

    public Response dummyOperation(EnumSerializationForcer forcer) throws Exception {
        return null;
    }

    public SettingsDescriptor getSessionSettings() throws Exception {
        try {
            SettingsDescriptor toReturn = new SettingsDescriptor();
            ASLSession session = Utils.getSession((HttpSession)this.getThreadLocalRequest().getSession());
            toReturn.setSpeciesSearchDescriptor((SpeciesSearchDescriptor)session.getAttribute("SPECIES_SEARCH_FILTER"));
            for (ClientResourceType t : ClientResourceType.values()) {
                if (!session.hasAttribute(t + "")) continue;
                toReturn.getResources().put(t, ModelTranslation.toClient((Resource)((DataManagement)AbstractPlugin.dataManagement().build()).loadResource(((Integer)session.getAttribute(t + "")).intValue())));
            }
            return toReturn;
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw new Exception("Session might be expired");
        }
    }

    public Response setSource(ClientResource selected) throws Exception {
        try {
            ASLSession session = Utils.getSession((HttpSession)this.getThreadLocalRequest().getSession());
            session.setAttribute(selected.getType() + "", (Object)selected.getSearchId());
            return new Response(Boolean.valueOf(true));
        }
        catch (Exception e) {
            logger.error("Set source ", (Throwable)e);
            return new Response(Boolean.valueOf(false));
        }
    }

    public Response retrieveMapPerSpeciesList(List<String> species) throws Exception {
        try {
            ASLSession session = Utils.getSession((HttpSession)this.getThreadLocalRequest().getSession());
            DBManager.getInstance((String)session.getScope()).cleanMaps(session.getUsername());
            ArrayList<CompoundMapItem> retrieved = new ArrayList<CompoundMapItem>();
            for (AquaMap map : ((Publisher)AbstractPlugin.publisher().build()).getMapsBySpecies(species.toArray(new String[species.size()]), true, true, null)) {
                retrieved.add(ModelTranslation.toClient((AquaMap)map));
            }
            int count = DBManager.getInstance((String)session.getScope()).putMaps(session.getUsername(), retrieved);
            Response toReturn = new Response(Boolean.valueOf(true));
            toReturn.getAdditionalObjects().put("RETRIEVED_MAPS", count + "");
            return toReturn;
        }
        catch (Exception e) {
            logger.error("Unable to Retrieve Maps from selection " + species, (Throwable)e);
            Response toReturn = new Response(Boolean.valueOf(false));
            toReturn.getAdditionalObjects().put("ERROR_MESSAGE", "Session might be expired");
            return toReturn;
        }
    }

    public SaveOperationProgress getSaveProgress() throws Exception {
        return SaveManager.getProgress((ASLSession)Utils.getSession((HttpSession)this.getThreadLocalRequest().getSession()));
    }

    public SaveOperationProgress saveOperationRequest(SaveRequest request) throws Exception {
        return SaveManager.startSaving((SaveRequest)request, (ASLSession)Utils.getSession((HttpSession)this.getThreadLocalRequest().getSession()));
    }

    public List<String> getDefaultLayers() throws Exception {
        try {
            return (List)AquaMapsXStream.deSerialize((String)(this.getServletContext().getRealPath("") + layersPath));
        }
        catch (Exception e) {
            logger.error("Unable to read default layers", (Throwable)e);
            return new ArrayList<String>();
        }
    }

    public String loadSpeciesByMapsId(String id) throws Exception {
        ASLSession session = Utils.getSession((HttpSession)this.getThreadLocalRequest().getSession());
        Maps am = (Maps)AbstractPlugin.maps().build();
        AquaMapsObject object = am.loadObject(Integer.parseInt(id));
        String speciesId = ((Species)object.getSelectedSpecies().iterator().next()).getId();
        int hspenId = (Integer)session.getAttribute(ResourceType.HSPEN + "");
        String jsonSource = am.getJSONSpecies(hspenId, Arrays.asList(new Filter(FilterType.is, new Field(SpeciesOccursumFields.speciesid + "", speciesId, FieldType.STRING))), new ArrayList(), new PagedRequestSettings(1, 0, SpeciesOccursumFields.speciesid + "", OrderDirection.ASC));
        String jsonObjString = jsonSource.substring(jsonSource.indexOf(91) + 1, jsonSource.lastIndexOf(93));
        JSONObject obj = new JSONObject(jsonObjString);
        return obj.getString(SpeciesOccursumFields.genus + "") + "_" + obj.getString(SpeciesOccursumFields.species + "");
    }
}

