/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsspeciesview.client.maps;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.GroupingStore;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.grid.CellEditor;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.EditorGrid;
import com.extjs.gxt.ui.client.widget.grid.GridGroupRenderer;
import com.extjs.gxt.ui.client.widget.grid.GridView;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.tips.ToolTipConfig;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.LoadListener;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Date;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.constants.AquaMapsSpeciesViewConstants;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.constants.resources.Resources;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.maps.MapsDetailsPanel;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.data.CompoundMapItem;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.data.DetailsParameter;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.data.ImageItem;

public class MapsDetailsPanel
extends ContentPanel {
    private ContentPanel imageContainer = new ContentPanel((Layout)new FitLayout());
    private ListStore<ImageItem> imageStore = new ListStore();
    private GroupingStore<DetailsParameter> store = new GroupingStore();
    private Image image = new Image();
    private Image layerPreview = new Image();
    private Button save;
    private Button gis;
    private Image loading = new Image();
    private static final String GENERIC_GROUP = "Generic Information";
    private static final String GIS_GROUP = "GIS Information";
    private static final String GENERATION_GROUP = "Generation Information";
    private CompoundMapItem current = null;

    public MapsDetailsPanel() {
        this.setFrame(true);
        this.setSize(700, 450);
        this.setLayout((Layout)new FitLayout());
        this.setHeading("Map Details");
        this.image.setTitle("Map Preview");
        this.image.setAltText("");
        ContentPanel gridPanel = new ContentPanel();
        gridPanel.setLayout((Layout)new FitLayout());
        gridPanel.setHeading("Meta Information");
        gridPanel.setCollapsible(true);
        gridPanel.collapse();
        this.store.groupBy(DetailsParameter.PARAMETER_GROUP);
        ArrayList<ColumnConfig> columns = new ArrayList<ColumnConfig>();
        ColumnConfig name = new ColumnConfig(DetailsParameter.PARAMETER_NAME, "Parameter", 100);
        columns.add(name);
        ColumnConfig value = new ColumnConfig(DetailsParameter.PARAMETER_VALUE, "Value", 100);
        columns.add(value);
        value.setEditor((CellEditor)new /* Unavailable Anonymous Inner Class!! */);
        ColumnModel cm = new ColumnModel(columns);
        2 view = new /* Unavailable Anonymous Inner Class!! */;
        view.setShowGroupedColumn(false);
        view.setForceFit(true);
        view.setAutoFill(true);
        view.setSortingEnabled(false);
        view.setStartCollapsed(true);
        view.setGroupRenderer((GridGroupRenderer)new /* Unavailable Anonymous Inner Class!! */);
        EditorGrid grid = new EditorGrid((ListStore)this.store, cm);
        grid.addListener(Events.AfterEdit, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        grid.addListener(Events.BeforeEdit, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        grid.setHideHeaders(true);
        grid.setView((GridView)view);
        grid.setBorders(true);
        grid.setHeight(300);
        grid.setWidth(340);
        grid.setStripeRows(true);
        grid.removeStyleName("x-unselectable");
        gridPanel.add((Widget)grid);
        this.imageContainer.setHeading("Static Images");
        this.imageContainer.setCollapsible(true);
        this.imageContainer.collapse();
        this.imageContainer.setFrame(true);
        this.imageContainer.setHeight(500);
        6 imageView = new /* Unavailable Anonymous Inner Class!! */;
        imageView.setTemplate(this.getTemplate());
        imageView.setStore(this.imageStore);
        imageView.setItemSelector("div.thumb-wrap");
        imageView.getSelectionModel().addListener(Events.SelectionChange, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        imageView.setId("img-details-view");
        imageView.setWidth(340);
        this.imageContainer.add((Widget)imageView);
        ContentPanel layerPanel = new ContentPanel();
        layerPanel.setLayout((Layout)new FitLayout());
        layerPanel.setCollapsible(true);
        layerPanel.setHeading("Layer Preview");
        layerPanel.add((Widget)this.layerPreview);
        this.layerPreview.setTitle("Layer Preview");
        this.layerPreview.setAltText("");
        this.layerPreview.addLoadListener((LoadListener)new /* Unavailable Anonymous Inner Class!! */);
        this.loading.setPixelSize(340, 240);
        this.loading.setUrl(GWT.getModuleBaseURL() + "img/loading.gif");
        this.add((Widget)this.image);
        this.add((Component)gridPanel);
        this.add((Component)this.imageContainer);
        this.add((Component)layerPanel);
        this.setScrollMode(Style.Scroll.AUTOY);
        this.save = new Button("Save", Resources.ICONS.disk(), (SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.save.disable();
        this.save.setToolTip(new ToolTipConfig("Save", "Save current map to workspace"));
        this.gis = new Button("GIS Viewer", Resources.ICONS.world(), (SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.gis.setToolTip(new ToolTipConfig("GIS Viewer", "Open current map in GIS Viewer"));
        this.gis.disable();
        ToolBar bar = new ToolBar();
        bar.add((Component)this.save);
        bar.add((Component)this.gis);
        this.setBottomComponent((Component)bar);
    }

    public void setData(CompoundMapItem data) {
        this.mask("Loading details..");
        this.current = data;
        this.save.enable();
        if (data.isGis().booleanValue()) {
            this.gis.enable();
        } else {
            this.gis.disable();
        }
        this.setHeading(data.getTitle() + " details.");
        this.image.setUrl(data.getImageThumbNail());
        this.image.setAltText("Static image for " + data);
        this.image.setTitle(data.getTitle());
        this.image.setPixelSize(340, 240);
        ArrayList<DetailsParameter> toAdd = new ArrayList<DetailsParameter>();
        toAdd.add(new DetailsParameter((String)AquaMapsSpeciesViewConstants.mapFieldsNames.get("title"), data.getTitle(), GENERIC_GROUP));
        toAdd.add(new DetailsParameter((String)AquaMapsSpeciesViewConstants.mapFieldsNames.get("author"), data.getAuthor(), GENERIC_GROUP));
        toAdd.add(new DetailsParameter((String)AquaMapsSpeciesViewConstants.mapFieldsNames.get("type_field"), data.getType(), GENERIC_GROUP));
        toAdd.add(new DetailsParameter((String)AquaMapsSpeciesViewConstants.mapFieldsNames.get("image_count"), data.getImageCount() + "", GENERIC_GROUP));
        toAdd.add(new DetailsParameter((String)AquaMapsSpeciesViewConstants.mapFieldsNames.get("gis"), data.isGis() + "", GENERIC_GROUP));
        toAdd.add(new DetailsParameter((String)AquaMapsSpeciesViewConstants.mapFieldsNames.get("custom"), data.isCustom() + "", GENERIC_GROUP));
        toAdd.add(new DetailsParameter((String)AquaMapsSpeciesViewConstants.mapFieldsNames.get("creation_date"), AquaMapsSpeciesViewConstants.timeFormat.format(new Date(data.getCreationDate())), GENERATION_GROUP));
        toAdd.add(new DetailsParameter((String)AquaMapsSpeciesViewConstants.mapFieldsNames.get("resource_id"), data.getResourceId() + "", GENERATION_GROUP));
        toAdd.add(new DetailsParameter((String)AquaMapsSpeciesViewConstants.mapFieldsNames.get("algorithm"), data.getAlgorithm(), GENERATION_GROUP));
        toAdd.add(new DetailsParameter((String)AquaMapsSpeciesViewConstants.mapFieldsNames.get("data_generation_time"), AquaMapsSpeciesViewConstants.timeFormat.format(new Date(data.getDataGenerationTime())), GENERATION_GROUP));
        toAdd.add(new DetailsParameter((String)AquaMapsSpeciesViewConstants.mapFieldsNames.get("layer_id"), data.getLayerId(), GIS_GROUP));
        toAdd.add(new DetailsParameter((String)AquaMapsSpeciesViewConstants.mapFieldsNames.get("layer_url"), data.getLayerUrl(), GIS_GROUP));
        this.store.removeAll();
        this.store.add(toAdd);
        ArrayList<ImageItem> toAddImages = new ArrayList<ImageItem>();
        for (String uri : data.getImageList().split(",")) {
            toAddImages.add(new ImageItem(uri));
        }
        this.imageStore.removeAll();
        this.imageStore.add(toAddImages);
        this.layerPreview.setUrl(data.getLayerPreview());
        this.layerPreview.setPixelSize(340, 240);
        this.layerPreview.setVisible(false);
        this.loading.setVisible(true);
        this.unmask();
        Log.debug((String)("store contains : " + this.store.getModels().size()));
    }

    private native String getTemplate();

    static /* synthetic */ ContentPanel access$000(MapsDetailsPanel x0) {
        return x0.imageContainer;
    }

    static /* synthetic */ ListStore access$100(MapsDetailsPanel x0) {
        return x0.imageStore;
    }

    static /* synthetic */ Image access$200(MapsDetailsPanel x0) {
        return x0.layerPreview;
    }

    static /* synthetic */ Image access$300(MapsDetailsPanel x0) {
        return x0.loading;
    }

    static /* synthetic */ CompoundMapItem access$400(MapsDetailsPanel x0) {
        return x0.current;
    }
}

