/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsspeciesview.servlet.db;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.io.FileUtils;
import org.apache.derby.tools.ij;
import org.gcube.application.aquamaps.aquamapsspeciesview.servlet.db.DBManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConnectionProvider {
    protected static final String DB_DIR = "AquaMapsSpeciesViewServlet_DB";
    protected static final String DB_DRIVER_CLASS = "org.apache.derby.jdbc.EmbeddedDriver";
    protected static String dbDirPath;
    private static final ConcurrentHashMap<String, CountDownLatch> initializedScopes;
    private static final Logger log;

    public static Set<String> initializedScopes() {
        return initializedScopes.keySet();
    }

    public static Connection connect(String scope) throws Exception {
        try {
            if (initializedScopes.putIfAbsent(scope, new CountDownLatch(1)) == null) {
                log.debug("First Access to " + scope + " db, initialiizing...");
                log.debug("Nobody else is constructing DB, preceding...");
                String tmpDirName = System.getProperty("java.io.tmpdir");
                File tmpDir = new File(tmpDirName);
                dbDirPath = ConnectionProvider.getDBPath((String)scope);
                File dbDir = new File(tmpDir, dbDirPath);
                ConnectionProvider.initializeDB((File)dbDir);
                ((CountDownLatch)initializedScopes.get(scope)).countDown();
            }
        }
        catch (InterruptedException e) {
            log.debug("Woken up by end of DB Construction, going to connect..");
        }
        catch (Exception e) {
            log.error("UNABLE TO INIT DB UNDER SCOPE " + scope, (Throwable)e);
            initializedScopes.remove(scope);
        }
        return ConnectionProvider.connectDB((String)scope);
    }

    public static void dropDataBase(String scope) {
        log.debug("Removing db instance for scope " + scope);
        initializedScopes.remove(scope);
        String tmpDirName = System.getProperty("java.io.tmpdir");
        File tmpDir = new File(tmpDirName);
        String dbDirPath = ConnectionProvider.getDBPath((String)scope);
        File dbDir = new File(tmpDir, dbDirPath);
        if (dbDir.exists()) {
            try {
                Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
                String connectionUrl = "jdbc:derby:" + dbDir.getAbsolutePath() + ";shutdown=true";
                log.debug("Connection url: " + connectionUrl);
                DriverManager.getConnection(connectionUrl);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                log.debug("Deleting dbDir: " + dbDir.getAbsolutePath());
                FileUtils.deleteDirectory((File)dbDir);
            }
            catch (IOException e) {
                log.warn("Unable to delete folder " + dbDir.getAbsolutePath(), (Throwable)e);
            }
        }
    }

    private static String getDBPath(String scope) {
        return "AquaMapsSpeciesViewServlet_DB" + scope.replaceAll("/", "-");
    }

    private static void initializeDB(File dbDir) throws Exception {
        try {
            Connection connection;
            log.debug("Initializing DB Dir: " + dbDir.getAbsolutePath());
            dbDirPath = dbDir.getAbsolutePath();
            if (dbDir.exists()) {
                log.debug("Init Process, Deleting existing dir " + dbDir.getAbsolutePath());
                try {
                    FileUtils.deleteDirectory((File)dbDir);
                }
                catch (IOException e) {
                    log.error("Error removing the dbDir: " + dbDir.getAbsolutePath(), (Throwable)e);
                    throw new Exception("Error initializing the db", e);
                }
            }
            try {
                Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new Exception("Error loading jdbc driver class: org.apache.derby.jdbc.EmbeddedDriver", e);
            }
            String connectionUrl = "jdbc:derby:" + dbDir.getAbsolutePath() + ";create=true";
            log.debug("Connection url: " + connectionUrl);
            try {
                connection = DriverManager.getConnection(connectionUrl);
            }
            catch (SQLException e) {
                throw new Exception("Error connecting to the db with url: ", e);
            }
            try {
                ConnectionProvider.executeBatch((Connection)connection, (String)"sql/createTables.sql");
            }
            catch (Exception e) {
                log.error("Error creating the schemas", (Throwable)e);
                throw new Exception("Error initializing the db", e);
            }
        }
        catch (Exception e) {
            if (dbDir.exists()) {
                log.debug("Something went wrong, Deleting existing dir " + dbDir.getAbsolutePath());
                try {
                    FileUtils.deleteDirectory((File)dbDir);
                }
                catch (IOException e1) {
                    log.error("Error removing the dbDir: " + dbDir.getAbsolutePath(), (Throwable)e1);
                    throw new Exception("Error initializing the db", e1);
                }
            }
            throw e;
        }
    }

    private static void executeBatch(Connection connection, String batchFile) throws Exception {
        int exceptions;
        FileOutputStream fos;
        File tmpOut;
        log.debug("executeBatch " + batchFile);
        InputStream batchStream = DBManager.class.getResourceAsStream(batchFile);
        try {
            tmpOut = File.createTempFile("batchExecution", "log");
            fos = new FileOutputStream(tmpOut);
        }
        catch (IOException e) {
            log.error("Error creating the tmp out file", (Throwable)e);
            throw e;
        }
        try {
            exceptions = ij.runScript((Connection)connection, (InputStream)batchStream, (String)"UTF-8", (OutputStream)fos, (String)"UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Error executing the batch sql", (Throwable)e);
            throw e;
        }
        if (log.isTraceEnabled() || exceptions > 0) {
            try {
                String line;
                LineNumberReader lnr = new LineNumberReader(new FileReader(tmpOut));
                while ((line = lnr.readLine()) != null) {
                    if (exceptions <= 0) continue;
                    log.error(line);
                }
                lnr.close();
            }
            catch (FileNotFoundException e) {
                log.error("Error reading the output batch file", (Throwable)e);
            }
            catch (IOException e) {
                log.error("Error reading the output batch file", (Throwable)e);
            }
        }
        tmpOut.delete();
        if (exceptions > 0) {
            throw new Exception(exceptions + " exceptions during script batch execution.");
        }
    }

    private static Connection connectDB(String scope) throws Exception {
        Connection connection;
        try {
            ((CountDownLatch)initializedScopes.get(scope)).await();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        String tmpDirName = System.getProperty("java.io.tmpdir");
        File tmpDir = new File(tmpDirName);
        dbDirPath = ConnectionProvider.getDBPath((String)scope);
        File dbDir = new File(tmpDir, dbDirPath);
        dbDir.mkdirs();
        log.debug("Connecting dbDir: " + dbDir.getAbsolutePath());
        dbDirPath = dbDir.getAbsolutePath();
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        }
        catch (ClassNotFoundException e) {
            log.error("Error loading jdbc driver class: org.apache.derby.jdbc.EmbeddedDriver", (Throwable)e);
            throw new Exception("Error initializing the db", e);
        }
        String connectionUrl = "jdbc:derby:" + dbDir.getAbsolutePath();
        log.debug("Connection url: " + connectionUrl);
        try {
            connection = DriverManager.getConnection(connectionUrl);
        }
        catch (SQLException e) {
            log.error("Error connecting to the db with url: " + connectionUrl, (Throwable)e);
            throw new Exception("Error initializing the db", e);
        }
        return connection;
    }

    static {
        initializedScopes = new ConcurrentHashMap();
        log = LoggerFactory.getLogger(ConnectionProvider.class);
    }
}

