/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsspeciesview.servlet.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.sf.csv4j.CSVLineProcessor;
import net.sf.csv4j.CSVReaderProcessor;
import org.apache.commons.io.FileUtils;
import org.gcube.application.aquamaps.aquamapsservice.client.plugins.AbstractPlugin;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.DataManagement;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.PagedRequestSettings;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.ExportOperation;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.FieldType;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.data.CompoundMapItem;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.fields.SpeciesFields;
import org.gcube.application.aquamaps.aquamapsspeciesview.servlet.db.ConnectionProvider;
import org.gcube.application.aquamaps.aquamapsspeciesview.servlet.db.DBInterface;
import org.gcube.application.aquamaps.aquamapsspeciesview.servlet.db.DBSession;
import org.gcube.application.aquamaps.aquamapsspeciesview.servlet.db.DBUtil;
import org.gcube.application.aquamaps.aquamapsspeciesview.servlet.db.SpeciesCSVProcessor;
import org.gcube.application.aquamaps.aquamapsspeciesview.servlet.db.Tables;
import org.gcube.application.aquamaps.aquamapsspeciesview.servlet.utils.Utils;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBManager
implements DBInterface {
    private static final Logger log = LoggerFactory.getLogger(DBManager.class);
    protected DBSession session;
    private String associatedScope;
    private long lastUpdateTime;

    public static Set<String> getInitializedScopes() {
        return ConnectionProvider.initializedScopes();
    }

    public static void deleteDb(String currentScope) throws Exception {
        log.debug("Delete dbinterface for scope " + currentScope);
        String scope = Utils.removeVRE((String)currentScope);
        ConnectionProvider.dropDataBase((String)scope);
    }

    public static DBInterface getInstance(String currentScopeString) throws Exception {
        log.debug("getDBInterface for scope : " + currentScopeString);
        String scope = Utils.removeVRE((String)currentScopeString);
        return new DBManager(scope);
    }

    protected DBManager(String scope) throws Exception {
        this.associatedScope = scope;
        this.session = new DBSession(scope);
        log.debug("Checking DB connection ...");
        this.session.executeQuery("SELECT * from " + Tables.kingdom);
        this.retrieveSpeciesFields();
    }

    public String getPhylogenyJSON(String level) throws Exception {
        log.debug("get Phylogeny for lvel : " + level);
        try (ResultSet rs = null;){
            String table = level;
            if (level.equalsIgnoreCase(SpeciesFields.ordercolumn + "")) {
                table = Tables.order_table + "";
            }
            if (level.equalsIgnoreCase(SpeciesFields.classcolumn + "")) {
                table = Tables.class_table + "";
            }
            if (level.equalsIgnoreCase(SpeciesFields.familycolumn + "")) {
                table = Tables.family_table + "";
            }
            rs = this.session.executeQuery("SELECT * FROM " + table);
            String string = DBUtil.toJSon((ResultSet)rs);
            return string;
        }
    }

    public String getMaps(String mapRequestId, PagedRequestSettings settings) throws Exception {
        try (ResultSet rs = null;){
            log.debug("Getting maps by request id  (" + mapRequestId + ")");
            ArrayList<Field> key = new ArrayList<Field>();
            key.add(new Field("requestid", mapRequestId, FieldType.STRING));
            rs = this.session.executeFilteredQuery(key, Tables.MAPS + "", settings.orderField(), settings.orderDirection() + "");
            String string = DBUtil.toJSon((ResultSet)rs, (int)settings.offset(), (int)(settings.offset() + settings.limit()));
            return string;
        }
    }

    private void retrieveSpeciesFields() throws SQLException {
    }

    public Integer putMaps(String mapRequestId, List<CompoundMapItem> items) throws Exception {
        try (Statement ps = null;){
            int count = 0;
            for (CompoundMapItem item : items) {
                ArrayList<Field> values = new ArrayList<Field>();
                values.add(new Field("algorithm", item.getAlgorithm(), FieldType.STRING));
                values.add(new Field("author", item.getAuthor(), FieldType.STRING));
                values.add(new Field("coverage_field", item.getCoverage(), FieldType.STRING));
                values.add(new Field("creation_date", item.getCreationDate() + "", FieldType.LONG));
                values.add(new Field("data_generation_time", item.getDataGenerationTime() + "", FieldType.LONG));
                values.add(new Field("fileset_id", item.getFileSetId(), FieldType.STRING));
                values.add(new Field("gis", item.isGis() + "", FieldType.BOOLEAN));
                values.add(new Field("image_count", item.getImageCount() + "", FieldType.INTEGER));
                values.add(new Field("image_list", item.getImageList(), FieldType.STRING));
                values.add(new Field("layer_id", item.getLayerId(), FieldType.STRING));
                values.add(new Field("layer_preview", item.getLayerPreview(), FieldType.STRING));
                values.add(new Field("layer_url", item.getLayerUrl(), FieldType.STRING));
                values.add(new Field("resource_id", item.getResourceId() + "", FieldType.INTEGER));
                values.add(new Field("species_list", item.getSpeciesList(), FieldType.STRING));
                values.add(new Field("thumbnail", item.getImageThumbNail(), FieldType.STRING));
                values.add(new Field("title", item.getTitle(), FieldType.STRING));
                values.add(new Field("type_field", item.getType(), FieldType.STRING));
                values.add(new Field("custom", item.isCustom() + "", FieldType.BOOLEAN));
                values.add(new Field("requestid", mapRequestId, FieldType.STRING));
                if (ps == null) {
                    ps = this.session.getPreparedStatementForInsert(values, Tables.MAPS + "");
                }
                try {
                    count += this.session.fillParameters(values, 0, (PreparedStatement)ps).executeUpdate();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.warn("Unable to insert map item " + item, (Throwable)e);
                }
            }
            this.session.commit();
            Integer n = count;
            return n;
        }
    }

    public void cleanMaps(String requestId) throws Exception {
        try {
            ArrayList<Field> row = new ArrayList<Field>();
            row.add(new Field("requestid", requestId, FieldType.STRING));
            this.session.deleteOperation(Tables.MAPS + "", row);
            this.session.commit();
        }
        catch (Exception e) {
            this.session.connection.rollback();
            throw e;
        }
    }

    public boolean isUpToDate() {
        return System.currentTimeMillis() - this.lastUpdateTime < 300000L;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getAssociatedScope() {
        return this.associatedScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchSpecies() throws RemoteException, Exception {
        File csvFile = null;
        try {
            ScopeProvider.instance.set(this.associatedScope.toString());
            csvFile = ((DataManagement)AbstractPlugin.dataManagement().withTimeout(2, TimeUnit.MINUTES).build()).exportTableAsCSV("speciesoccursum", null, null, null, ExportOperation.TRANSFER);
            CSVReaderProcessor processor = new CSVReaderProcessor();
            processor.setDelimiter(',');
            processor.setHasHeader(true);
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(csvFile), Charset.defaultCharset());
            SpeciesCSVProcessor lineProcessor = new SpeciesCSVProcessor(this.session);
            log.debug("Starting file processing");
            processor.processStream((Reader)reader, (CSVLineProcessor)lineProcessor);
            log.debug("Complete processing");
            this.setLastUpdateTime(System.currentTimeMillis());
        }
        finally {
            try {
                if (csvFile != null && csvFile.exists()) {
                    FileUtils.forceDelete((File)csvFile);
                }
            }
            catch (Exception e) {
                log.error("Unable to delete csv File " + csvFile.getAbsolutePath());
            }
        }
    }
}

