/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsspeciesview.servlet.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.FieldType;
import org.gcube.application.aquamaps.aquamapsspeciesview.servlet.db.ConnectionProvider;
import org.gcube.application.aquamaps.aquamapsspeciesview.servlet.db.DBSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DBSession {
    private static final Logger logger = LoggerFactory.getLogger(DBSession.class);
    protected Connection connection;
    private String scope;

    public DBSession(String scope) throws Exception {
        this.scope = scope;
        this.connection = ConnectionProvider.connect((String)scope);
    }

    public String getScope() {
        return this.scope;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void close() throws Exception {
        this.connection.close();
    }

    public void disableAutoCommit() throws Exception {
        this.connection.setAutoCommit(false);
    }

    public void commit() throws Exception {
        this.connection.commit();
    }

    @Deprecated
    public ResultSet executeQuery(String query) throws Exception {
        logger.debug("DIRECT QUERY IS : " + query);
        Statement statement = this.connection.createStatement(1004, 1007);
        return statement.executeQuery(query);
    }

    public void disableKeys(String tableName) throws Exception {
        Statement statement = this.connection.createStatement();
        statement.execute("alter table " + tableName + " DISABLE KEYS");
        statement.close();
    }

    public void enableKeys(String tableName) throws Exception {
        Statement statement = this.connection.createStatement();
        statement.execute("alter table " + tableName + " ENABLE KEYS");
        statement.close();
    }

    public void createIndex(String tableName, String columnName) throws Exception {
        Statement statement = this.connection.createStatement();
        StringBuilder createQuery = new StringBuilder("CREATE INDEX IDX_" + tableName + "_" + columnName + " ON " + tableName + "(" + columnName + ");");
        logger.debug("the query is: " + createQuery.toString());
        statement.executeUpdate(createQuery.toString());
        statement.close();
    }

    public void deleteColumn(String tableName, String columnName) throws Exception {
        Statement statement = this.connection.createStatement();
        String query = "ALTER TABLE " + tableName + " drop column " + columnName;
        logger.debug("the query is: " + query);
        statement.executeUpdate(query.toString());
        statement.close();
    }

    public void dropTable(String table) throws Exception {
        Statement statement = this.connection.createStatement();
        statement.executeUpdate("DROP TABLE IF EXISTS " + table + " ");
        statement.close();
    }

    public List<List<String>> showTableMetadata(String tableName, String ... whereClause) throws Exception {
        String query = "SHOW COLUMNS FROM " + tableName + " " + (whereClause != null && whereClause.length > 0 ? "WHERE " + whereClause[0] : "") + ";";
        logger.debug("executing query: " + query);
        ResultSet rs = this.executeQuery(query);
        int columns = rs.getMetaData().getColumnCount();
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        while (rs.next()) {
            ArrayList<String> row = new ArrayList<String>();
            for (int i = 1; i <= columns; ++i) {
                row.add(rs.getString(i));
            }
            table.add(row);
        }
        return table;
    }

    protected PreparedStatement getPreparedStatementForCount(List<Field> filters, String tableName) throws SQLException {
        return this.connection.prepareStatement(DBSession.formSelectCountString(filters, (String)tableName));
    }

    public PreparedStatement getPreparedStatementForQuery(List<Field> filters, String table, String orderColumn, String orderDirection) throws SQLException {
        return this.connection.prepareStatement(DBSession.formSelectQueryStringFromFields(filters, (String)table, (String)orderColumn, (String)orderDirection));
    }

    public PreparedStatement getPreparedStatementForUpdate(List<Field> toSet, List<Field> keys, String tableName) throws SQLException {
        return this.connection.prepareStatement(DBSession.formUpdateQuery(toSet, keys, (String)tableName), 1);
    }

    public PreparedStatement getPreparedStatementForInsertFromSelect(List<Field> fields, String destTable, String srcTable) throws Exception {
        String query = "INSERT INTO " + destTable + " ( " + DBSession.formSelectQueryStringFromFields(fields, (String)srcTable, null, null) + " )";
        logger.debug("the prepared statement is :" + query);
        PreparedStatement ps = this.preparedStatement(query);
        return ps;
    }

    public PreparedStatement getPreparedStatementForInsert(List<Field> fields, String table) throws Exception {
        StringBuilder fieldsName = new StringBuilder("(");
        StringBuilder fieldsValues = new StringBuilder("(");
        for (Field f : fields) {
            fieldsValues.append("?,");
            fieldsName.append(f.name() + ",");
        }
        logger.debug(" the values are " + fields.size());
        fieldsValues.deleteCharAt(fieldsValues.length() - 1);
        fieldsValues.append(")");
        fieldsName.deleteCharAt(fieldsName.length() - 1);
        fieldsName.append(")");
        String query = "INSERT INTO " + table + " " + fieldsName + " VALUES " + fieldsValues;
        logger.debug("the prepared statement is :" + query);
        PreparedStatement ps = this.connection.prepareStatement(query, 1);
        return ps;
    }

    public PreparedStatement getPreparedStatementForDelete(List<Field> fields, String table) throws Exception {
        PreparedStatement ps = this.preparedStatement(DBSession.formDeletetQueryStringFromFields(fields, (String)table));
        return ps;
    }

    @Deprecated
    public PreparedStatement preparedStatement(String query) throws Exception {
        logger.debug("Prepared statement : " + query);
        return this.connection.prepareStatement(query, 1004, 1007);
    }

    public PreparedStatement fillParameters(List<Field> fields, int parameterOffset, PreparedStatement ps) throws SQLException {
        block9: for (int i = 0; i < fields.size(); ++i) {
            Field f = fields.get(i);
            switch (1.$SwitchMap$org$gcube$application$aquamaps$aquamapsservice$stubs$fw$types$FieldType[f.type().ordinal()]) {
                case 1: {
                    Integer value = f.getValueAsBoolean() != false ? 1 : 0;
                    ps.setInt(i + 1 + parameterOffset, value);
                    continue block9;
                }
                case 2: {
                    ps.setDouble(i + 1 + parameterOffset, f.getValueAsDouble());
                    continue block9;
                }
                case 3: {
                    try {
                        ps.setInt(i + 1 + parameterOffset, f.getValueAsInteger());
                    }
                    catch (NumberFormatException e) {
                        ps.setLong(i + 1 + parameterOffset, Long.parseLong(f.value()));
                    }
                    continue block9;
                }
                case 4: {
                    ps.setString(i + 1 + parameterOffset, f.value());
                    continue block9;
                }
                case 5: {
                    ps.setLong(i + 1 + parameterOffset, f.getValueAsLong());
                }
            }
        }
        return ps;
    }

    public List<List<Field>> insertOperation(String tableName, List<List<Field>> rows) throws Exception {
        ArrayList<List<Field>> toReturn = new ArrayList<List<Field>>();
        if (rows.size() == 0) {
            throw new Exception("Empty rows to insert");
        }
        PreparedStatement ps = this.getPreparedStatementForInsert(rows.get(0), tableName);
        for (List<Field> row : rows) {
            ps = this.fillParameters(row, 0, ps);
            if (ps.executeUpdate() <= 0) continue;
            toReturn.addAll(this.getGeneratedKeys(ps));
        }
        logger.debug("INSERTED " + toReturn.size() + " ENTRIES");
        return toReturn;
    }

    public int updateOperation(String tableName, List<List<Field>> keys, List<List<Field>> rows) throws Exception {
        int count = 0;
        if (rows.size() == 0) {
            throw new Exception("Empty rows to insert");
        }
        if (keys.size() == 0) {
            throw new Exception("Empty keys");
        }
        if (rows.size() != keys.size()) {
            throw new Exception("Un matching rows/keys sizes " + rows.size() + "/" + keys.size());
        }
        PreparedStatement ps = this.getPreparedStatementForUpdate(rows.get(0), keys.get(0), tableName);
        for (int i = 0; i < rows.size(); ++i) {
            ps = this.fillParameters(rows.get(i), 0, ps);
            ps = this.fillParameters(keys.get(i), rows.get(i).size(), ps);
            count += ps.executeUpdate();
        }
        return count;
    }

    public ResultSet executeFilteredQuery(List<Field> filters, String table, String orderColumn, String orderMode) throws Exception {
        PreparedStatement ps = this.getPreparedStatementForQuery(filters, table, orderColumn, orderMode);
        return this.fillParameters(filters, 0, ps).executeQuery();
    }

    public int getCount(String tableName, List<Field> filters) throws Exception {
        PreparedStatement ps = this.getPreparedStatementForCount(filters, tableName);
        ResultSet rs = this.fillParameters(filters, 0, ps).executeQuery();
        if (rs.next()) {
            return rs.getInt(1);
        }
        return 0;
    }

    public int deleteOperation(String tableName, List<Field> filters) throws Exception {
        PreparedStatement ps = this.getPreparedStatementForDelete(filters, tableName);
        int count = this.fillParameters(filters, 0, ps).executeUpdate();
        logger.debug("DELETED " + count + " ENTRIES");
        return count;
    }

    public int getTableCount(String tableName) throws Exception {
        Statement statement = this.connection.createStatement();
        ResultSet rs = statement.executeQuery("SELECT COUNT(*) FROM " + tableName);
        rs.next();
        return rs.getInt(1);
    }

    @Deprecated
    public int executeUpdate(String query) throws Exception {
        Statement statement = this.connection.createStatement();
        return statement.executeUpdate(query);
    }

    protected List<List<Field>> getGeneratedKeys(PreparedStatement ps) throws SQLException {
        ResultSet rs = ps.getGeneratedKeys();
        ResultSetMetaData rsMeta = rs.getMetaData();
        ArrayList<List<Field>> toReturn = new ArrayList<List<Field>>();
        while (rs.next()) {
            ArrayList<Field> row = new ArrayList<Field>();
            for (int i = 1; i <= rsMeta.getColumnCount(); ++i) {
                row.add(new Field(rsMeta.getColumnName(i), rs.getString(i), FieldType.STRING));
            }
            toReturn.add(row);
        }
        return toReturn;
    }

    protected static String formSelectQueryStringFromFields(List<Field> filters, String table, String sortColumn, String sortDirection) {
        String toReturn = "SELECT * FROM " + table + (filters != null && filters.size() > 0 ? " WHERE " + DBSession.getCondition(filters, (String)"AND") : "") + (sortColumn != null ? " ORDER BY " + sortColumn + " " + sortDirection : "");
        logger.debug("QUERY STRING IS : " + toReturn);
        return toReturn;
    }

    protected static String formSelectCountString(List<Field> filters, String tableName) {
        String toReturn = "SELECT COUNT(*) FROM " + tableName + (filters != null && filters.size() > 0 ? " WHERE " + DBSession.getCondition(filters, (String)"AND") : "");
        logger.debug("QUERY STRING IS : " + toReturn);
        return toReturn;
    }

    protected static String formDeletetQueryStringFromFields(List<Field> filters, String table) {
        String toReturn = "DELETE FROM " + table + (filters != null && filters.size() > 0 ? " WHERE " + DBSession.getCondition(filters, (String)"AND") : "");
        logger.debug("QUERY STRING IS : " + toReturn);
        return toReturn;
    }

    protected static String formUpdateQuery(List<Field> toSet, List<Field> keys, String tableName) {
        String toReturn = "UPDATE " + tableName + " SET " + DBSession.getCondition(toSet, (String)",") + (keys != null && keys.size() > 0 ? " WHERE " + DBSession.getCondition(keys, (String)"AND") : "");
        logger.debug("QUERY STRING IS : " + toReturn);
        return toReturn;
    }

    private static String getCondition(List<Field> filters, String operator) {
        StringBuilder query = new StringBuilder();
        if (filters != null && filters.size() > 0) {
            for (Field f : filters) {
                query.append(" " + f.name() + " = ? " + operator);
            }
            query.delete(query.lastIndexOf(operator), query.lastIndexOf(operator) + operator.length());
        }
        return query + "";
    }
}

