/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.tests;

import java.util.List;
import java.util.function.Predicate;
import org.gcube.application.cms.plugins.InitializablePlugin;
import org.gcube.application.cms.plugins.Plugin;
import org.gcube.application.cms.plugins.faults.InitializationException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

public class BasicPluginTest {
    static List<Plugin> plugins;

    @BeforeClass
    public static void checkPluginRegistration() {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().forPackage("org.gcube.application.cms", new ClassLoader[0]).filterInputsBy((Predicate)new FilterBuilder().includePackage("org.gcube.application.cms")));
        reflections.getSubTypesOf(Plugin.class).iterator().forEachRemaining(pluginClass -> {
            if (!pluginClass.isInterface()) {
                try {
                    Plugin plugin = (Plugin)pluginClass.newInstance();
                    plugins.add(plugin);
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                    Assert.fail((String)("Unable to Load " + pluginClass));
                }
            }
        });
        Assert.assertFalse((boolean)plugins.isEmpty());
        System.out.println("Plugin Loading OK");
    }

    @Test
    public void basicChecks() {
        plugins.forEach(p -> {
            System.out.println("INIT Plugin " + p.getClass());
            Assert.assertNotNull((Object)p.getDescriptor());
            Assert.assertNotNull((Object)p.getDescriptor().getId());
            Assert.assertNotNull((Object)p.getDescriptor().getType());
            Assert.assertNotNull((Object)p.getDescriptor().getVersion());
            if (p instanceof InitializablePlugin) {
                InitializablePlugin ip = (InitializablePlugin)p;
                try {
                    ip.init();
                }
                catch (InitializationException e) {
                    e.printStackTrace(System.err);
                    Assert.fail((String)("Unable to Init " + p.getDescriptor().getId()));
                }
            }
        });
    }
}

