/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.tests.plugins;

import java.util.function.BiConsumer;
import junit.framework.TestCase;
import org.gcube.application.cms.plugins.IndexerPluginInterface;
import org.gcube.application.cms.plugins.InitializablePlugin;
import org.gcube.application.cms.plugins.LifecycleManager;
import org.gcube.application.cms.plugins.MaterializationPlugin;
import org.gcube.application.cms.plugins.Plugin;
import org.gcube.application.cms.tests.TokenSetter;
import org.gcube.application.geoportal.common.utils.tests.GCubeTest;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginCheks {
    private static final Logger log = LoggerFactory.getLogger(PluginCheks.class);
    static BiConsumer<String, Plugin> init = (s, p) -> {
        if (p instanceof InitializablePlugin) {
            log.info("INIT Plugin " + p.getDescriptor());
            InitializablePlugin ip = (InitializablePlugin)p;
            try {
                ip.init().validate();
                if (GCubeTest.isTestInfrastructureEnabled()) {
                    log.info("INIT Plugin " + p.getDescriptor() + " under " + GCubeTest.getContext());
                    TokenSetter.set(GCubeTest.getContext());
                    ip.initInContext().validate();
                }
            }
            catch (Exception e) {
                log.error("Unable to init {} ", p, (Object)e);
                Assert.fail((String)("Unable to Init " + p.getDescriptor().getId()));
            }
        }
    };
    static BiConsumer<String, Plugin> descriptor = (s, p) -> {
        log.info("Checking Plugin Descriptor " + p.getClass());
        Assert.assertNotNull((Object)p.getDescriptor());
        Assert.assertNotNull((Object)p.getDescriptor().getId());
        Assert.assertNotNull((Object)p.getDescriptor().getType());
        switch (p.getDescriptor().getType()) {
            case "LifecycleManagement": {
                TestCase.assertTrue((boolean)(p instanceof LifecycleManager));
                break;
            }
            case "Materializer": {
                TestCase.assertTrue((boolean)(p instanceof MaterializationPlugin));
                break;
            }
            case "Indexer": {
                TestCase.assertTrue((boolean)(p instanceof IndexerPluginInterface));
                break;
            }
        }
    };
}

