/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.notifications.gis;

import java.util.Map;
import org.gcube.portlets.user.uriresolvermanager.UriResolverManager;
import org.gcube.portlets.user.uriresolvermanager.resolvers.query.GeoportalResolverQueryStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GisClient {
    private static final Logger log = LoggerFactory.getLogger(GisClient.class);

    public static String gisLink(GeoportalResolverQueryStringBuilder.RESOLVE_AS resolveAs, String profileID, String projectID, String scope, boolean shortLink) {
        log.debug("called gisLink as {} for scope {}, profileId {}, projectId {} ", new Object[]{resolveAs, scope, profileID, projectID});
        String theLink = "";
        try {
            log.debug("Trying to generate Geoportal Gis Link...");
            UriResolverManager uriResolverManager = new UriResolverManager("GEO");
            GeoportalResolverQueryStringBuilder builder = new GeoportalResolverQueryStringBuilder(profileID, projectID);
            builder.scope(scope);
            builder.resolverAs(resolveAs);
            Map params = builder.buildQueryParameters();
            theLink = uriResolverManager.getLink(params, shortLink);
            log.info("Geoportal GisViewer link is {} ", (Object)theLink);
        }
        catch (Exception e) {
            log.error("Error on creating the Geoportal GisViewer link for project id {}", (Object)projectID, (Object)e);
        }
        return theLink;
    }
}

