/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.notifications.config.serviceaccount;

import java.util.AbstractMap;
import java.util.Map;
import javax.ws.rs.InternalServerErrorException;
import org.gcube.application.cms.notifications.config.serviceaccount.IAMClientCredentials;
import org.gcube.application.cms.notifications.config.serviceaccount.IAMClientCredentialsReader;
import org.gcube.common.authorization.utils.manager.SecretManagerProvider;
import org.gcube.common.authorization.utils.secret.JWTSecret;
import org.gcube.common.authorization.utils.secret.Secret;
import org.gcube.common.keycloak.KeycloakClientFactory;
import org.gcube.common.keycloak.model.TokenResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoportalServiceAccount {
    private static final Logger log = LoggerFactory.getLogger(GeoportalServiceAccount.class);
    protected static final String CLIENT_ID_PROPERTY_NAME = "clientId";
    private static String clientId = "geoportal";

    private static Map.Entry<String, String> getClientIdAndClientSecret(String context) {
        try {
            IAMClientCredentials credentials = IAMClientCredentialsReader.getCredentials();
            clientId = credentials.getClientId() == null ? clientId : credentials.getClientId();
            String clientSecret = credentials.getClientSecret();
            AbstractMap.SimpleEntry<String, String> entry = new AbstractMap.SimpleEntry<String, String>(clientId, clientSecret);
            return entry;
        }
        catch (Exception e) {
            throw new InternalServerErrorException("Unable to retrieve Application Token for context " + SecretManagerProvider.instance.get().getContext(), (Throwable)e);
        }
    }

    private static TokenResponse getJWTAccessToken() throws Exception {
        String context = SecretManagerProvider.instance.get().getContext();
        Map.Entry<String, String> entry = GeoportalServiceAccount.getClientIdAndClientSecret(context);
        TokenResponse tr = KeycloakClientFactory.newInstance().queryUMAToken(context, entry.getKey(), entry.getValue(), context, null);
        return tr;
    }

    public static Secret getGeoportalSecret() throws Exception {
        TokenResponse tr = GeoportalServiceAccount.getJWTAccessToken();
        JWTSecret secret = new JWTSecret(tr.getAccessToken());
        return secret;
    }
}

