/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.notifications.substitutor;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.text.StringSubstitutor;
import org.gcube.application.cms.notifications.substitutor.SubstitutorMessagesMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NMessagesPlaceholdersSubstitutorUtil {
    private static final Logger log = LoggerFactory.getLogger(NMessagesPlaceholdersSubstitutorUtil.class);
    private String linkToNotificationMessages;
    private Properties notificationMessagesProperties;
    private SubstitutorMessagesMap placeholderMapValues;
    private StringSubstitutor stringSub;

    public NMessagesPlaceholdersSubstitutorUtil(String linkToNotificationMessages) throws IOException {
        this.linkToNotificationMessages = linkToNotificationMessages;
        try (BufferedInputStream in = new BufferedInputStream(new URL(linkToNotificationMessages).openStream());){
            this.notificationMessagesProperties = new Properties();
            this.notificationMessagesProperties.load(in);
        }
        catch (IOException e) {
            log.error("Error on reading notificationMessagesFileURL for input: {}", (Object)linkToNotificationMessages, (Object)e);
            throw e;
        }
    }

    public String getLinkToNotificationMessages() {
        return this.linkToNotificationMessages;
    }

    public void setPlaceholderMapValues(SubstitutorMessagesMap placeholderMapValues) {
        this.placeholderMapValues = placeholderMapValues;
        this.stringSub = new StringSubstitutor((Map)placeholderMapValues);
    }

    public String replacePlaceholder(String notificationPlaceholder) {
        if (notificationPlaceholder == null || notificationPlaceholder.isEmpty()) {
            return notificationPlaceholder;
        }
        log.trace("stringSub is {}", (Object)this.stringSub);
        if (this.stringSub != null) {
            log.debug("notificationPlaceholder: {}", (Object)notificationPlaceholder);
            String templateString = this.notificationMessagesProperties.getProperty(notificationPlaceholder);
            log.debug("templateString: {}", (Object)templateString);
            String resolvedString = this.stringSub.replace(templateString);
            log.debug("resolvedString: {}", (Object)resolvedString);
            return resolvedString;
        }
        log.info("placeholderMapValues is null, returning source: {}", (Object)notificationPlaceholder);
        return notificationPlaceholder;
    }

    public SubstitutorMessagesMap getPlaceholderMapValues() {
        return this.placeholderMapValues;
    }
}

