package org.gcube.application.cms.notifications.config.serviceaccount;

import java.util.AbstractMap.SimpleEntry;
import java.util.Map.Entry;

import javax.ws.rs.InternalServerErrorException;

import org.gcube.common.authorization.utils.manager.SecretManagerProvider;
import org.gcube.common.authorization.utils.secret.JWTSecret;
import org.gcube.common.authorization.utils.secret.Secret;
import org.gcube.common.keycloak.KeycloakClientFactory;
import org.gcube.common.keycloak.model.TokenResponse;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class GeoportalServiceAccount {

	//geoportal service account config property file
	protected static final String CLIENT_ID_PROPERTY_NAME = "clientId";
	
	private static String clientId = "geoportal";
	
	private static Entry<String, String> getClientIdAndClientSecret(String context) {
		try {
			IAMClientCredentials credentials = IAMClientCredentialsReader.getCredentials();
			
			clientId = credentials.getClientId()==null?clientId:credentials.getClientId();
			String clientSecret = credentials.getClientSecret();
			SimpleEntry<String, String> entry = new SimpleEntry<String, String>(clientId, clientSecret);
			return entry;
		} catch(Exception e) {
			throw new InternalServerErrorException(
					"Unable to retrieve Application Token for context " + SecretManagerProvider.instance.get().getContext(), e);
		}
	}
	
	private static TokenResponse getJWTAccessToken() throws Exception {
		String context = SecretManagerProvider.instance.get().getContext();
		Entry<String,String> entry = getClientIdAndClientSecret(context);
		TokenResponse tr = KeycloakClientFactory.newInstance().queryUMAToken(context, entry.getKey(), entry.getValue(), context, null);
	    return tr;
	}
	
	public static Secret getGeoportalSecret() throws Exception {
		TokenResponse tr = getJWTAccessToken();
		Secret secret = new JWTSecret(tr.getAccessToken());
		return secret;
	}
	
}
