/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.sdi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;
import org.gcube.application.cms.plugins.faults.InvalidProfileException;
import org.gcube.application.cms.sdi.model.ApplyRegex;
import org.gcube.application.cms.serialization.Serialization;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.HandlerDeclaration;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.UseCaseDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingObject {
    private static final Logger log = LoggerFactory.getLogger(MappingObject.class);
    private String name;
    private String type;
    private String path;
    @JsonProperty(value="apply_regex")
    private ApplyRegex applyRegex;

    public void validate() throws InvalidProfileException {
        if (this.name == null) {
            throw new InvalidProfileException("Invalid mapping " + this + " : name is null");
        }
        if (this.type == null) {
            throw new InvalidProfileException("Invalid mapping " + this + " : type is null");
        }
        if (this.path == null) {
            throw new InvalidProfileException("Invalid mapping " + this + " : path is null");
        }
    }

    public static List<MappingObject> getMappingsFromUCD(UseCaseDescriptor ucd, String handlerID) throws InvalidProfileException {
        log.debug("UseCaseDescriptor {} : Evaluating Index schema.. ", (Object)ucd.getId());
        HandlerDeclaration handler = (HandlerDeclaration)((List)ucd.getHandlersMapByID().get(handlerID)).get(0);
        log.trace("Handler is {} ", (Object)handler);
        Document profileConfiguration = handler.getConfiguration();
        List mappingObjs = (List)profileConfiguration.get((Object)"explicitFieldMapping", List.class);
        log.trace("Loading mappings from useCaseDescriptor.. ");
        ArrayList<MappingObject> mappingObjects = new ArrayList<MappingObject>();
        if (mappingObjs != null) {
            for (Object mappingObj : mappingObjs) {
                log.trace("Mapping is {} ", mappingObj);
                MappingObject m = (MappingObject)Serialization.convert(mappingObj, MappingObject.class);
                m.validate();
                mappingObjects.add(m);
            }
        }
        return mappingObjects;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getPath() {
        return this.path;
    }

    public ApplyRegex getApplyRegex() {
        return this.applyRegex;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setApplyRegex(ApplyRegex applyRegex) {
        this.applyRegex = applyRegex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MappingObject)) {
            return false;
        }
        MappingObject other = (MappingObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        ApplyRegex this$applyRegex = this.getApplyRegex();
        ApplyRegex other$applyRegex = other.getApplyRegex();
        return !(this$applyRegex == null ? other$applyRegex != null : !((Object)this$applyRegex).equals(other$applyRegex));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MappingObject;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        ApplyRegex $applyRegex = this.getApplyRegex();
        result = result * 59 + ($applyRegex == null ? 43 : ((Object)$applyRegex).hashCode());
        return result;
    }

    public String toString() {
        return "MappingObject(name=" + this.getName() + ", type=" + this.getType() + ", path=" + this.getPath() + ", applyRegex=" + this.getApplyRegex() + ")";
    }
}

