/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.enm.service.plugins.comps;

import com.bsc.venusbes.jobdescription.VENUSCJobGenerator;
import com.bsc.venusbes.venusclient.VENUSClient;
import com.bsc.venusbes.venusclient.credentials.BESCredential;
import com.bsc.venusbes.venusclient.credentials.StorageCredential;
import com.bsc.venusbes.venusclient.types.JobProgress;
import com.bsc.venusbes.venusclient.types.JobStatus;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class COMPSsClient {
    private String address;

    public COMPSsClient(String endpoint) {
        this.address = endpoint;
    }

    public String submitModel(BESCredential besCred, StorageCredential cred, Integer wallClockTime, String VMImage, Double diskSize, Integer cores, Double memory, Integer minOfVMs, Integer maxOfVMs, String jobName, String appLocation, String logsDir, String requests, String testPoints, String outputs) {
        String jobId = null;
        String executable = "modeller.Modeller";
        try {
            VENUSClient venusClient = new VENUSClient(this.address, besCred);
            VENUSCJobGenerator VENUSCJob = new VENUSCJobGenerator();
            VENUSCJob.createJobIdentification(jobName, "OpenBIO OModeller");
            VENUSCJob.createApplication(new URL(appLocation), cred);
            VENUSCJob.setExecutable(executable);
            VENUSCJob.createArgument("true");
            StringTokenizer st = new StringTokenizer(requests, "/");
            String requestsName = null;
            while (st.hasMoreElements()) {
                requestsName = st.nextToken();
            }
            st = new StringTokenizer(testPoints, "/");
            String tPoints = null;
            while (st.hasMoreElements()) {
                tPoints = st.nextToken();
            }
            st = new StringTokenizer(outputs, "/");
            String outputDir = null;
            while (st.hasMoreElements()) {
                outputDir = st.nextToken();
            }
            VENUSCJob.createArgument("/sharedDisk/" + requestsName + "/");
            VENUSCJob.createArgument("/sharedDisk/" + tPoints);
            VENUSCJob.createArgument("/home/user/IT/" + executable + "/" + outputDir + "/");
            VENUSCJob.setVMInfo(VMImage, diskSize);
            VENUSCJob.setVMCores(cores);
            VENUSCJob.setVMMemory(memory);
            VENUSCJob.setMinVMs(minOfVMs);
            VENUSCJob.setMaxVMs(maxOfVMs);
            VENUSCJob.setWallClockTime(wallClockTime);
            VENUSCJob.createStageIn(String.valueOf(requestsName) + "/", new URL(requests), cred);
            VENUSCJob.createStageIn(tPoints, new URL(testPoints), cred);
            String outputPath = outputs.substring(0, outputs.length() - (String.valueOf(outputDir) + 1).length());
            VENUSCJob.createStageOut(String.valueOf(outputDir) + "/", new URL(outputPath), cred);
            VENUSCJob.createLogs(new URL(logsDir), cred);
            VENUSCJob.generateJobDescription();
            jobId = venusClient.createActivity(VENUSCJob.getJobDefinition());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jobId;
    }

    public List<JobStatus> OModellerStatus(BESCredential besCred, String[] jobIds) {
        VENUSClient venusClient = new VENUSClient(this.address, besCred);
        List status = null;
        try {
            status = venusClient.getActivityStatus(jobIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public List<JobProgress> getJobsProgress(BESCredential besCred, String[] jobIds) {
        VENUSClient venusClient = new VENUSClient(this.address, besCred);
        ArrayList<JobProgress> progressList = new ArrayList();
        try {
            progressList = venusClient.getJobsProgress(jobIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return progressList;
    }

    public List<String> terminateOModeller(BESCredential besCred, String[] jobIds) {
        VENUSClient venusClient = new VENUSClient(this.address, besCred);
        List messageList = null;
        try {
            messageList = venusClient.terminateActivity(jobIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return messageList;
    }

    public int getCompletness(BESCredential besCred, String[] jobIds) {
        List<JobProgress> progress;
        if (jobIds != null && jobIds.length > 0 && (progress = this.getJobsProgress(besCred, jobIds)) != null && progress.get(0).getTotal() > 0) {
            return (int)((float)progress.get(0).getCompleted().intValue() / (float)progress.get(0).getTotal().intValue() * 100.0f);
        }
        return 0;
    }
}

