/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.enm.service.plugins.comps;

import com.bsc.venusbes.venusclient.credentials.BESCredential;
import com.bsc.venusbes.venusclient.credentials.FTPCredential;
import com.bsc.venusbes.venusclient.credentials.StorageCredential;
import com.bsc.venusbes.venusclient.types.JobStatus;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import org.gcube.application.enm.common.xml.logs.ExperimentLogs;
import org.gcube.application.enm.common.xml.logs.LogType;
import org.gcube.application.enm.common.xml.request.ExperimentRequest;
import org.gcube.application.enm.common.xml.request.RequestType;
import org.gcube.application.enm.common.xml.results.ExperimentResults;
import org.gcube.application.enm.common.xml.results.ResultType;
import org.gcube.application.enm.common.xml.status.ExperimentStatus;
import org.gcube.application.enm.common.xml.status.ObjectFactory;
import org.gcube.application.enm.common.xml.status.StatusType;
import org.gcube.application.enm.service.ExecutionException;
import org.gcube.application.enm.service.ExecutionResource;
import org.gcube.application.enm.service.conn.FtpClient;
import org.gcube.application.enm.service.conn.InformationSystemClient;
import org.gcube.application.enm.service.conn.StorageClientUtil;
import org.gcube.application.enm.service.plugins.comps.COMPSsClient;
import org.gcube.contentmanagement.blobstorage.service.IClient;

public class COMPsExecutionResource
extends ExecutionResource {
    private static final String FTP_BASEDIR = "/openbiotest/enm";
    private final InformationSystemClient.FtpCredentials ftpCred;
    private final BESCredential besCred;
    private final StorageCredential storageCred;
    private final InformationSystemClient.COMPSsCredentials compssCred;
    private final InformationSystemClient.OpenModellerImage omImage;

    public COMPsExecutionResource() {
        this.ftpCred = this.isClient.getCOMPSFtpCredentials();
        this.compssCred = this.isClient.getCOMPSsCredentials();
        this.besCred = new BESCredential(this.compssCred.getBesUsername(), this.compssCred.getBesPassword());
        this.storageCred = new FTPCredential(this.compssCred.getStorageUsername(), this.compssCred.getStoragePassword());
        this.omImage = this.isClient.getOpenModellerImage();
    }

    @Override
    public final String sumbitExperiment(UUID uuid, ExperimentRequest params) {
        String jobId = null;
        boolean shouldClean = false;
        try {
            this.uploadExperimentInput(uuid, params);
            shouldClean = true;
            COMPSsClient enmService = new COMPSsClient(this.compssCred.getEndpoint());
            InformationSystemClient.VmInstance vmInstance = this.isClient.getVmInstance(params.getInstance());
            String logsDir = this.absoluteFtpPath(this.getExperimentLogsDir(uuid));
            String requestsDir = this.absoluteFtpPath(this.getExperimentRequestDir(uuid));
            String testingPointsFile = this.absoluteFtpPath(this.getExperimentDir(uuid), params.getTestingPoints().getName());
            String resultsDir = this.absoluteFtpPath(this.getExperimentResultsDir(uuid));
            this.logger.trace((Object)("Logs dir: '" + logsDir + "', Requests dir: '" + requestsDir + "', Testing points file: '" + testingPointsFile + ", Results dir: '" + resultsDir + "'"));
            jobId = enmService.submitModel(this.besCred, this.storageCred, this.omImage.getWallClock(), this.omImage.getVmImage(), vmInstance.getDisSizeGB(), vmInstance.getCores(), vmInstance.getMemoryGB(), vmInstance.getMinVMs(), vmInstance.getMaxVMs(), this.omImage.getJobNamePrefix(), this.omImage.getAppLocation(), logsDir, requestsDir, testingPointsFile, resultsDir);
            if (jobId == null) {
                throw new ExecutionException("Unknown error");
            }
        }
        catch (ExecutionException e) {
            if (shouldClean) {
                try {
                    this.cleanExperiment(uuid);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            jobId = null;
            this.logger.error((Object)("Failed to submit experiment: " + e.getLocalizedMessage()));
        }
        return jobId;
    }

    private void uploadExperimentInput(UUID uuid, ExperimentRequest params) throws ExecutionException {
        FtpClient ftp = null;
        boolean shouldClean = false;
        try {
            try {
                String[] dirs;
                ftp = this.connectFtp();
                String[] stringArray = dirs = new String[]{this.getExperimentDir(uuid), this.getExperimentRequestDir(uuid), this.getExperimentLogsDir(uuid)};
                int n = dirs.length;
                int n2 = 0;
                while (n2 < n) {
                    String dirname = stringArray[n2];
                    ftp.makeDirectory(dirname);
                    ++n2;
                }
                shouldClean = true;
                for (RequestType request : params.getRequests().getRequest()) {
                    ftp.uploadString(request.getRequest(), String.valueOf(this.getExperimentRequestDir(uuid)) + "/" + request.getName());
                }
                ftp.uploadString(params.getTestingPoints().getTestPoints(), String.valueOf(this.getExperimentDir(uuid)) + "/" + params.getTestingPoints().getName());
            }
            catch (IOException e) {
                if (ftp != null && shouldClean) {
                    try {
                        ftp.deleteDir(this.getExperimentDir(uuid));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw new ExecutionException("Failed to upload experiment input: " + e.getLocalizedMessage());
            }
        }
        finally {
            if (ftp != null) {
                ftp.disconnect();
            }
        }
    }

    private FtpClient connectFtp() throws IOException {
        FtpClient ftp = new FtpClient();
        ftp.connect(this.ftpCred.getServer(), this.ftpCred.getPort(), this.ftpCred.getUsername(), this.ftpCred.getPassword());
        if (!ftp.changeDirectory(FTP_BASEDIR)) {
            throw new IOException("Cannot change the FTP working directory to: /openbiotest/enm");
        }
        return ftp;
    }

    private void cleanExperiment(UUID uuid) throws ExecutionException {
        FtpClient ftp = null;
        try {
            try {
                ftp = this.connectFtp();
                ftp.deleteDir(this.getExperimentDir(uuid));
            }
            catch (IOException e) {
                throw new ExecutionException("Failed to clean experiment directory: " + e.getLocalizedMessage());
            }
        }
        finally {
            if (ftp != null) {
                ftp.disconnect();
            }
        }
    }

    private String getExperimentDir(UUID uuid) {
        return uuid.toString();
    }

    private String getExperimentRequestDir(UUID uuid) {
        return String.valueOf(this.getExperimentDir(uuid)) + "/requests";
    }

    private String getExperimentLogsDir(UUID uuid) {
        return String.valueOf(this.getExperimentDir(uuid)) + "/logs";
    }

    private String getExperimentResultsDir(UUID uuid) {
        return String.valueOf(this.getExperimentDir(uuid)) + "/results";
    }

    private String baseFtpPath() {
        return "ftp://" + this.ftpCred.getServer() + FTP_BASEDIR + "/";
    }

    private String absoluteFtpPath(String relativePath) {
        return this.absoluteFtpPath(relativePath, "");
    }

    private String absoluteFtpPath(String relativePath, String filename) {
        return String.valueOf(this.baseFtpPath()) + relativePath + "/" + filename;
    }

    @Override
    public final ExperimentStatus getStatus(UUID uuid, String jobId) {
        ExperimentStatus experimentStatus = null;
        String[] jobIds = new String[]{jobId};
        COMPSsClient enmService = new COMPSsClient(this.compssCred.getEndpoint());
        List<JobStatus> status = enmService.OModellerStatus(this.besCred, jobIds);
        if (status != null && status.size() == 1 && status.get(0) != null) {
            experimentStatus = new ObjectFactory().createExperimentStatus();
            experimentStatus.setCompletenessPercentage(new BigDecimal(0));
            if (status.get(0).getStatus().equals("RUNNING_STAGE_OUT")) {
                experimentStatus.setStatus(StatusType.EXECUTING);
                experimentStatus.setCompletenessPercentage(new BigDecimal(100));
            } else if (status.get(0).getStatus().startsWith("RUNNING")) {
                experimentStatus.setStatus(StatusType.EXECUTING);
            } else if (status.get(0).getStatus().equals("FINISHED")) {
                experimentStatus.setStatus(StatusType.FINISHED);
                experimentStatus.setCompletenessPercentage(new BigDecimal(100));
            } else if (status.get(0).getStatus().equals("FAILED")) {
                experimentStatus.setStatus(StatusType.FAILED);
            } else if (status.get(0).getStatus().equals("CANCELLED")) {
                experimentStatus.setStatus(StatusType.CANCELLED);
            } else {
                experimentStatus.setStatus(StatusType.PENDING);
            }
            experimentStatus.setDescription(status.get(0).getStatus());
            try {
                if (status.get(0).getStatus().equals("RUNNING_EXECUTING")) {
                    experimentStatus.setCompletenessPercentage(new BigDecimal(enmService.getCompletness(this.besCred, jobIds)));
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return experimentStatus;
    }

    @Override
    public final ExperimentResults getResults(UUID uuid, String jobId) {
        ExperimentResults results = new org.gcube.application.enm.common.xml.results.ObjectFactory().createExperimentResults();
        FtpClient ftp = null;
        try {
            try {
                String[] resFiles;
                ftp = this.connectFtp();
                String[] stringArray = resFiles = ftp.listFiles(this.getExperimentResultsDir(uuid));
                int n = resFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    String resfile = stringArray[n2];
                    ResultType result = new ResultType();
                    String resLocation = this.absoluteFtpPath(this.getExperimentResultsDir(uuid), resfile);
                    result.setRemoteJobId(jobId);
                    result.setOutputLocation(resLocation);
                    result.setFilename(new File(resfile).getName());
                    results.getResult().add(result);
                    ++n2;
                }
            }
            catch (IOException e) {
                this.logger.error((Object)("Failed to get experiment results: " + e.getLocalizedMessage()));
                if (ftp != null) {
                    ftp.disconnect();
                }
            }
        }
        finally {
            if (ftp != null) {
                ftp.disconnect();
            }
        }
        return results;
    }

    @Override
    public final ExperimentLogs getLogs(UUID uuid, String jobId) {
        ExperimentLogs logs = new org.gcube.application.enm.common.xml.logs.ObjectFactory().createExperimentLogs();
        FtpClient ftp = null;
        try {
            try {
                String[] logFiles;
                ftp = this.connectFtp();
                String[] stringArray = logFiles = ftp.listFiles(this.getExperimentLogsDir(uuid));
                int n = logFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    String logfile = stringArray[n2];
                    LogType log = new LogType();
                    String resLocation = this.absoluteFtpPath(this.getExperimentLogsDir(uuid), logfile);
                    log.setRemoteJobId(jobId);
                    log.setOutputLocation(resLocation);
                    log.setFilename(new File(logfile).getName());
                    logs.getLog().add(log);
                    ++n2;
                }
            }
            catch (IOException e) {
                this.logger.error((Object)("Failed to get experiment logs: " + e.getLocalizedMessage()));
                if (ftp != null) {
                    ftp.disconnect();
                }
            }
        }
        finally {
            if (ftp != null) {
                ftp.disconnect();
            }
        }
        return logs;
    }

    @Override
    public void cancelExperiment(UUID uuid, String jobId) {
        String[] jobIds = new String[]{jobId};
        COMPSsClient enmService = new COMPSsClient(this.compssCred.getEndpoint());
        List<String> messageList = enmService.terminateOModeller(this.besCred, jobIds);
        if (messageList != null) {
            for (String msg : messageList) {
                if (msg == null) continue;
                this.logger.trace((Object)msg);
            }
            try {
                this.cleanExperiment(uuid);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getResultAsFile(ResultType result, IClient storageClient, String credentials) {
        String id = null;
        FtpClient ftp = null;
        try {
            try {
                String remoteFilename = result.getOutputLocation().replace(this.baseFtpPath(), "");
                String localFilename = result.getOutputLocation().replace(this.baseFtpPath(), StorageClientUtil.userBaseDir(credentials));
                ftp = this.connectFtp();
                InputStream is = ftp.retrieveFileAsInputStream(remoteFilename);
                id = storageClient.put(true).LFile(is).RFile(localFilename);
            }
            catch (IOException e) {
                this.logger.error((Object)("Failed to retrieve experiment result: " + e.getLocalizedMessage()));
                if (ftp != null) {
                    ftp.disconnect();
                }
            }
            catch (Exception ex) {
                this.logger.error((Object)("Unkonwn error found while retrieving experiment result: " + ex.getLocalizedMessage()));
                if (ftp != null) {
                    ftp.disconnect();
                }
            }
        }
        finally {
            if (ftp != null) {
                ftp.disconnect();
            }
        }
        return id;
    }

    @Override
    public String getLogAsFile(LogType log, IClient storageClient, String credentials) {
        String id = null;
        FtpClient ftp = null;
        try {
            try {
                String remoteFilename = log.getOutputLocation().replace(this.baseFtpPath(), "");
                String localFilename = log.getOutputLocation().replace(this.baseFtpPath(), StorageClientUtil.userBaseDir(credentials));
                ftp = this.connectFtp();
                InputStream is = ftp.retrieveFileAsInputStream(remoteFilename);
                id = storageClient.put(true).LFile(is).RFile(localFilename);
            }
            catch (IOException e) {
                this.logger.error((Object)("Failed to retrieve experiment log: " + e.getLocalizedMessage()));
                if (ftp != null) {
                    ftp.disconnect();
                }
            }
            catch (Exception ex) {
                this.logger.error((Object)("Unkonwn error found while retrieving experiment log: " + ex.getLocalizedMessage()));
                if (ftp != null) {
                    ftp.disconnect();
                }
            }
        }
        finally {
            if (ftp != null) {
                ftp.disconnect();
            }
        }
        return id;
    }

    @Override
    public void cleanExperimentOuput(UUID uuid, String jobId) {
        try {
            this.cleanExperiment(uuid);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }
}

