package org.gcube.application.enm.service.concurrent;

import java.util.concurrent.atomic.AtomicLong;

/** 
 * Guarantees about the ordering of elements with equal priority in a priority 
 * queue. It uses a secondary key to break ties in primary priority values.
 * 
 * @see PriorityQueue
 * @see PriorityBlockingQueue
 * 
 * @author Erik Torres <ertorser@upv.es>
 */
public class FIFOEntry<E extends Comparable<? super E>>
implements Comparable<FIFOEntry<E>> {

	private static final AtomicLong seq = new AtomicLong(Long.MIN_VALUE);
	private final long seqNum;
	private final E entry;

	public FIFOEntry(final E entry) {
		seqNum = seq.getAndIncrement();
		this.entry = entry;
	}

	public E getEntry() { return entry; }

	@Override
	public int compareTo(final FIFOEntry<E> other) {
		int res = entry.compareTo(other.entry);
		if (res == 0 && other.entry != this.entry)			
			res = (seqNum < other.seqNum ? -1 : 1);
		return res;
	}

	@Override
	public boolean equals(final Object other) {
		if (other instanceof FIFOEntry<?>) {
			final FIFOEntry<?> fifoEntry = (FIFOEntry<?>) other;
			try {
				return entry.equals(fifoEntry.entry);
			} catch (Exception e) {
				// nothing to do
			}
		}
		return false;
	}

}
