/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.enm.service.conn;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.gcube.common.core.utils.logging.GCUBELog;

public class FtpClient {
    protected GCUBELog logger = new GCUBELog(FtpClient.class);
    private final FTPClient ftp = new FTPClient();

    public FtpClient() {
        this.logger.trace((Object)"Constructor...");
    }

    public void connect(String server, int port, String username, String password) throws IOException {
        int effectivePort = port > 0 ? port : this.ftp.getDefaultPort();
        this.ftp.connect(server, effectivePort);
        this.logger.trace((Object)("Connected to " + server + " on " + effectivePort));
        int reply = this.ftp.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            this.ftp.disconnect();
            throw new IOException("FTP server " + server + " refused connection");
        }
        this.ftp.login(username, password);
    }

    public boolean changeDirectory(String dirname) throws IOException {
        boolean res = this.ftp.changeWorkingDirectory(dirname);
        if (res) {
            this.logger.trace((Object)("New working directory is: " + dirname));
        }
        return res;
    }

    public String[] listFiles(String dirName) throws IOException {
        FTPFile[] files = this.ftp.listFiles(dirName);
        String[] filenames = null;
        if (files != null) {
            filenames = new String[files.length];
            int i = 0;
            while (i < files.length) {
                filenames[i] = files[i].getName();
                ++i;
            }
        }
        return filenames;
    }

    public InputStream retrieveFileAsInputStream(String filename) throws IOException {
        return this.ftp.retrieveFileStream(filename);
    }

    public String retrieveFileAsString(String filename) throws IOException {
        String line;
        InputStream is = this.retrieveFileAsInputStream(filename);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String content = "";
        while ((line = br.readLine()) != null) {
            content = String.valueOf(content) + line;
        }
        br.close();
        this.logger.trace((Object)("File retrieved: " + filename + "' from '" + this.ftp.printWorkingDirectory() + "'"));
        return content;
    }

    public void makeDirectory(String dirname) throws IOException {
        this.ftp.makeDirectory(dirname);
        this.logger.trace((Object)("New directory created: '" + dirname + "' on '" + this.ftp.printWorkingDirectory() + "'"));
    }

    public void uploadFile(String localFilename, String remoteFilename) throws IOException {
        FileInputStream input = new FileInputStream(localFilename);
        this.ftp.storeFile(remoteFilename, (InputStream)input);
        ((InputStream)input).close();
        this.logger.trace((Object)("File uploaded: " + remoteFilename + "' to '" + this.ftp.printWorkingDirectory() + "'"));
    }

    public void uploadString(String content, String remoteFilename) throws IOException {
        ByteArrayInputStream input = new ByteArrayInputStream(content.getBytes());
        this.ftp.storeFile(remoteFilename, (InputStream)input);
        ((InputStream)input).close();
        this.logger.trace((Object)("File uploaded: " + remoteFilename + "' to '" + this.ftp.printWorkingDirectory() + "'"));
    }

    public void deleteDir(String dirname) throws IOException {
        this.deleteDir(this.ftp, dirname);
    }

    public void disconnect() {
        try {
            if (this.ftp.isConnected()) {
                try {
                    this.ftp.logout();
                    this.ftp.disconnect();
                }
                catch (IOException ioe) {
                    this.logger.error((Object)ioe.getLocalizedMessage());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void deleteDir(FTPClient ftp, String dirName) throws IOException {
        FTPFile[] files;
        FTPFile[] fTPFileArray = files = ftp.listFiles(dirName);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            FTPFile file = fTPFileArray[n2];
            if (file.isDirectory()) {
                this.deleteDir(ftp, String.valueOf(dirName) + "/" + file.getName());
            } else {
                ftp.deleteFile(String.valueOf(dirName) + "/" + file.getName());
            }
            ++n2;
        }
        ftp.removeDirectory(dirName);
        this.logger.trace((Object)("Directory deleted: " + dirName + "' from '" + ftp.printWorkingDirectory() + "'"));
    }
}

