package org.gcube.application.enm.manager;

import java.rmi.RemoteException;
import org.gcube.application.enm.common.xml.bindings.Bindings;
import org.gcube.application.enm.common.xml.request.ExperimentRequest;
import org.gcube.application.enm.common.xml.status.ExperimentStatus;
import org.gcube.application.enm.context.ServiceContext;
import org.gcube.application.enm.stubs.ManagerPortType;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;

/**
 * Service manager.
 * 
 * @author Lucio Lelii <lucio.lelii@isti.cnr.it>
 */
public class Manager extends GCUBEPortType implements ManagerPortType {

	private static GCUBELog logger = new GCUBELog(Manager.class);
	
	/**{@inheritDoc}*/
	@Override	protected GCUBEServiceContext getServiceContext() {
		return ServiceContext.getContext();
	}

	
	@Override
	public String sumbitExperiment(String request) throws RemoteException {
		logger.trace("submit experiment method");
		try {
			String id = ServiceContext.getContext().getENMService().sumbitExperiment((ExperimentRequest)Bindings.fromXml(request));
			logger.trace("created job with id "+id);
			return id;
		} catch (Exception e) {
			logger.error("error in sumbitExperiment",e);
			throw new RemoteException("error binding ExperimentRequest class",e);
		}
	}

	@Override
	public String getStatus(String experimentId) throws RemoteException {
		logger.trace("getStatus method with experiment id "+experimentId);
		try {
			ExperimentStatus status =ServiceContext.getContext().getENMService().getStatus(experimentId);
			if (status==null) throw new Exception("invalid experiment id "+experimentId);
			return Bindings.toXml(status);
		} catch (Exception e) {
			logger.error("error in getStatus",e);
			throw new RemoteException("error binding ExperimentStatus class",e);
		}
		
	}

	@Override
	public String getResults(String experimentId) throws RemoteException {
		logger.trace("getResult method with experiment id "+experimentId);
		try {
			return Bindings.toXml(ServiceContext.getContext().getENMService().getResults(experimentId));
		} catch (Exception e) {
			logger.error("error in getResult",e);
			throw new RemoteException("error binding ExperimentResults class",e);
		}
	}

	@Override
	public String getLogs(String experimentId) throws RemoteException {
		logger.trace("getLogs method with experiment id "+experimentId);
		try {
			return Bindings.toXml(ServiceContext.getContext().getENMService().getLogs(experimentId));
		} catch (Exception e) {
			logger.error("error in getLogs",e);
			throw new RemoteException("error binding ExperimentLogs class",e);
		}
	}

	@Override
	public VOID cancelExperiment(String experimentId) throws RemoteException {
		logger.trace("cancel experiment method with experiment id "+experimentId);
		ServiceContext.getContext().getENMService().cancelExperiment(experimentId);
		return new VOID();
	}


	@Override
	public VOID removeExperiment(String experimentId) throws RemoteException {
		logger.trace("removeExperiment method with experiment id "+experimentId);
		ServiceContext.getContext().getENMService().removeExperiment(experimentId);
		return new VOID();
	}


	@Override
	public String getUserExperimentResumes(String credentials)
			throws RemoteException {
		logger.trace("getUserExperimentResumes method with credentials id "+credentials);
		try {
			return Bindings.toXml(ServiceContext.getContext().getENMService().getUserExperimentResumes(credentials));
		} catch (Exception e) {
			logger.error("error in getUserExperimentResumes",e);
			throw new RemoteException("error binding ExperimentResumes class",e);
		}
	}
	
	
}
