/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.gbifplugin.search.query;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.gbifplugin.search.query.MappingUtils;
import org.gcube.data.spd.gbifplugin.search.query.QueryCondition;
import org.gcube.data.spd.gbifplugin.search.query.ResultType;

public class QueryCount {
    protected GCUBELog log = new GCUBELog(QueryCount.class);
    @NonNull
    private String baseUri;
    List<QueryCondition> conditions = new ArrayList<QueryCondition>();
    @NonNull
    private ResultType resultType;

    public void setConditions(QueryCondition ... conditions) {
        this.conditions = Arrays.asList(conditions);
    }

    public int getCount() {
        Map<String, Object> mapping;
        block3: {
            try {
                mapping = MappingUtils.getObjectMapping(this.build());
                if (mapping.get("count") != null) break block3;
                return 0;
            }
            catch (Exception e) {
                this.log.error((Object)"error computing count, returning 0", (Throwable)e);
                return 0;
            }
        }
        return (Integer)mapping.get("count");
    }

    private String build() {
        StringBuilder query = new StringBuilder(this.baseUri);
        if (!this.baseUri.endsWith("/")) {
            query.append("/");
        }
        query.append(this.resultType.getQueryEntry()).append("/");
        query.append("search/?limit=0");
        if (this.conditions.size() > 0) {
            for (QueryCondition queryCond : this.conditions) {
                query.append("&").append(queryCond.getKey().replaceAll(" ", "%20")).append("=").append(queryCond.getValue().replaceAll(" ", "%20"));
            }
        }
        return query.toString();
    }

    @ConstructorProperties(value={"baseUri", "resultType"})
    public QueryCount(@NonNull String baseUri, @NonNull ResultType resultType) {
        if (baseUri == null) {
            throw new NullPointerException("baseUri");
        }
        if (resultType == null) {
            throw new NullPointerException("resultType");
        }
        this.baseUri = baseUri;
        this.resultType = resultType;
    }
}

