/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.gbifplugin.search;

import java.util.Map;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.gbifplugin.search.query.MappingUtils;
import org.gcube.data.spd.gbifplugin.search.query.QueryByIdentifier;
import org.gcube.data.spd.gbifplugin.search.query.QueryType;
import org.gcube.data.spd.model.products.DataProvider;
import org.gcube.data.spd.model.products.DataSet;

public class DataSetRetreiver {
    private static GCUBELog log = new GCUBELog(DataSetRetreiver.class);

    public static DataSet get(String key, String baseURL) throws Exception {
        long start = System.currentTimeMillis();
        QueryByIdentifier datasetQuery = new QueryByIdentifier(baseURL, key, QueryType.Dataset);
        Map<String, Object> mapping = MappingUtils.getObjectMapping(datasetQuery.build());
        DataSet dataset = new DataSet(key);
        dataset.setName(MappingUtils.getAsString(mapping, "title"));
        dataset.setCitation(MappingUtils.getAsString((Map)mapping.get("citation"), "text"));
        String providerKey = MappingUtils.getAsString(mapping, "publishingOrganizationKey");
        dataset.setDataProvider(DataSetRetreiver.getDataProvider(providerKey, baseURL));
        log.trace((Object)("[Benchmark] time to retrieve dataset is " + (System.currentTimeMillis() - start)));
        return dataset;
    }

    private static DataProvider getDataProvider(String key, String baseURL) throws Exception {
        QueryByIdentifier datasetQuery = new QueryByIdentifier(baseURL, key, QueryType.Organization);
        Map<String, Object> mapping = MappingUtils.getObjectMapping(datasetQuery.build());
        DataProvider dataProvider = new DataProvider(key);
        dataProvider.setName(MappingUtils.getAsString(mapping, "title"));
        return dataProvider;
    }
}

