package org.gcube.application.reporting;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

import org.gcube.application.reporting.reference.DBTableRow;
import org.gcube.portlets.d4sreporting.common.shared.Attribute;
import org.gcube.portlets.d4sreporting.common.shared.AttributeArea;
import org.gcube.portlets.d4sreporting.common.shared.BasicComponent;
import org.gcube.portlets.d4sreporting.common.shared.BasicSection;
import org.gcube.portlets.d4sreporting.common.shared.ComponentType;
import org.gcube.portlets.d4sreporting.common.shared.Tuple;
import org.gcube.portlets.d4sreporting.common.shared.Metadata;
import org.gcube.portlets.d4sreporting.common.shared.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author massi
 *
 */
public final class ReportsModeler implements Modeler {
	private static final Logger _log = LoggerFactory.getLogger(ReportsModeler.class);
	/**
	 * Styling attr, not used anymore but needed for backward compatibility
	 */
	public static final int TEMPLATE_WIDTH = 750;
	public static final int TEMPLATE_HEIGHT= 1000;
	public static final String DEFAULT_NAME = "no-name";
	private static final int MARGIN_LEFT = 0;
	private static final int MARGIN_RIGHT = 0;
	private static final int MARGIN_TOP = 0;
	private static final int MARGIN_BOTTOM = 0;
	private static final int COLUMN_WIDTH = 0;
	private static final int COMP_WIDTH = TEMPLATE_WIDTH - 50;
	private static final int COMP_HEIGHT = 35;

	private int currSection  = 1;
	/**
	 * model instance
	 */
	private Model model;
	/**
	 * 
	 * @param a the report unique idenntifier
	 * @param name the report name
	 * @param author the author
	 * @param dateCreated 
	 * @param lastEdit
	 * @param lastEditorId last editor username
	 */
	public ReportsModeler(String id, String name, String author, Date dateCreated, Date lastEdit, String lastEditorId) {
		model = new Model(
				id, 
				author, 
				dateCreated, 
				lastEdit, 
				lastEditorId, 
				name, 
				COLUMN_WIDTH, 
				1, // page to show
				MARGIN_BOTTOM, MARGIN_LEFT, MARGIN_RIGHT, MARGIN_TOP, TEMPLATE_HEIGHT, TEMPLATE_WIDTH, //useless params
				new Vector<BasicSection>(), 
				1, //total pages 
				new LinkedList<Metadata>());
		initialize();
	}
	/**
	 *{@inheritDoc} 
	 */
	@Override
	public boolean addTitle() {
		addTitle("", false);
		return false;
	}
	/**
	 *{@inheritDoc} 
	 */
	@Override
	public boolean addTitle(String content, boolean isReadonly) {
		BasicComponent bc = new BasicComponent(0, 0, COMP_WIDTH, COMP_HEIGHT, 
				1, ComponentType.TITLE, "", content, false, isReadonly, new ArrayList<Metadata>());		
		addComponentToSection(bc);
		return true;
	}
	/**
	 *{@inheritDoc} 
	 */
	@Override
	public boolean addHeading(int level) {
		return addHeading(level, "", false);
	}
	/**
	 *{@inheritDoc} 
	 */
	@Override
	public boolean addHeading(int level, String content) {
		return addHeading(level, content, true);
	}
	/**
	 *{@inheritDoc} 
	 */
	@Override
	public boolean addHeading(int level, String content, boolean isReadonly) {		
		addComponentToSection(getHeading(level, content, isReadonly));
		return true;
	}

	private BasicComponent getHeading(int level, String content, boolean isReadonly) {
		ComponentType type;
		switch (level) {
		case 1:
			type = ComponentType.HEADING_1;
			break;
		case 2:
			type = ComponentType.HEADING_2;
			break;
		case 3:
			type = ComponentType.HEADING_3;
			break;
		case 4:
			type = ComponentType.HEADING_4;
			break;
		case 5:
			type = ComponentType.HEADING_5;
			break;

		default:
			throw new IllegalArgumentException("Only heading level between 1 and 5 are supported");
		}

		return new BasicComponent(0, 0, COMP_WIDTH, COMP_HEIGHT, 
				1, type, "", content, false, isReadonly, new ArrayList<Metadata>());		

	}

	/**
	 *{@inheritDoc} 
	 */
	@Override
	public boolean addTextInput() {
		addTextInput("", false);
		return false;
	}

	/**
	 *{@inheritDoc} 
	 */
	@Override
	public boolean addTextInput(String content) {
		addComponentToSection( getTextInput(content, false));
		return true;
	}
	/**
	 *{@inheritDoc} 
	 */
	@Override
	public boolean addTextInput(String content, boolean isReadonly) {
		addComponentToSection( getTextInput(content, isReadonly));
		return true;
	}

	private BasicComponent getTextInput(String content, boolean isReadonly) {
		return new BasicComponent(0, 0, COMP_WIDTH, COMP_HEIGHT, 
				1, ComponentType.BODY_NOT_FORMATTED, "", content, false, isReadonly, new ArrayList<Metadata>());	
	}

	private BasicComponent getSequenceDelimiter() {
		return new BasicComponent(0, 0, COMP_WIDTH, 10, 
				1, ComponentType.REPEAT_SEQUENCE_DELIMITER, "", "", false, false, new ArrayList<Metadata>());	
	}

	/**
	 *{@inheritDoc} 
	 */
	@Override
	public boolean addInstruction(String content) {
		BasicComponent bc = new BasicComponent(0, 0, COMP_WIDTH, COMP_HEIGHT, 
				1, ComponentType.INSTRUCTION, "", content, false, false, new ArrayList<Metadata>());		
		addComponentToSection(bc);
		return true;
	}
	/**
	 *{@inheritDoc} 
	 */
	@Override
	public boolean addReference(List<DBTableRow> list) {
		ArrayList<Tuple> msL = new ArrayList<Tuple>();
		for (DBTableRow dBTableRow : list) {
			ArrayList<BasicComponent> groupedComponents = new ArrayList<BasicComponent>();
			groupedComponents.add(getSequenceDelimiter());
			for (Metadata md : dBTableRow.getMetadata()) {
				groupedComponents.add(getHeading(dBTableRow.getHeadingLevel(), md.getAttribute(), true));
				groupedComponents.add(getTextInput(md.getValue(), true));
			}
			groupedComponents.add(getSequenceDelimiter());
			msL.add(new Tuple(dBTableRow.getIdentifier(), groupedComponents));

		}

		BasicComponent toAdd = new BasicComponent(0, 0, COMP_WIDTH, COMP_HEIGHT, 
				1, ComponentType.TUPLE, "", msL, false, true, new ArrayList<Metadata>());	
		addComponentToSection(toAdd);
		return true;
	}
	/**
	 *{@inheritDoc} 
	 */
	public boolean addAttributeComponent(String attrName, ArrayList<Attribute> values, boolean allowMultiselection) {
		ComponentType type = allowMultiselection ? ComponentType.ATTRIBUTE_MULTI : ComponentType.ATTRIBUTE_UNIQUE;
		BasicComponent bc = new BasicComponent(0, 0, COMP_WIDTH, COMP_HEIGHT, 1, type, "", 
				new AttributeArea(attrName, values), false,	false, new ArrayList<Metadata>());		
		addComponentToSection(bc);
		return true;
	}
	/**
	 *{@inheritDoc} 
	 */
	@Override
	public boolean addMedia() {
		BasicComponent toAdd = new BasicComponent(0, 0, COMP_WIDTH, COMP_HEIGHT, 
				1, ComponentType.BODY_TABLE_IMAGE, "", null, false, true, new ArrayList<Metadata>());	
		
		addComponentToSection(toAdd);
		return true;
	}
	/**
	 *{@inheritDoc} 
	 */
	@Override
	public int nextSection() {
		currSection++;
		model.setTotalPages(currSection);
		return model.getTotalPages();
	}
	/**
	 * 
	 * @param bc the component to add
	 */
	private boolean addComponentToSection(BasicComponent bc) {
		if (model.getSections().isEmpty()) {
			BasicSection bs = new BasicSection();
			model.getSections().add(bs);
		} 
		if (currSection == (model.getSections().size()+1)) { // check the nextSection()
			BasicSection bs = new BasicSection();
			model.getSections().add(bs);
		} 
		if (currSection == model.getSections().size()) { // current section
			BasicSection bs = model.getSections().get(currSection-1);
			bs.getComponents().add(bc);
			return true;
		}
		else
			return false;
	}

	public Model getReportInstance() throws Exception {
		if (model.getSections().isEmpty())
			throw new Exception("The report is empty, has no sections.");
		return model;
	}

	/**
	 * 
	 * add a placeholder component at the beginning of the report (for backward compatibility)
	 */
	private void initialize() {
		BasicComponent bc = new BasicComponent(0, 0, COMP_WIDTH, COMP_HEIGHT, 1, ComponentType.FAKE_TEXTAREA, "", "", false, false,	new ArrayList<Metadata>());		
		addComponentToSection(bc);
	}

}
