/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.reporting;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gcube.application.reporting.ReportSequence;
import org.gcube.application.reporting.reference.DBTableRow;
import org.gcube.application.reporting.reference.ReferenceReport;
import org.gcube.application.reporting.reference.ReferenceReportType;
import org.gcube.portlets.d4sreporting.common.shared.Attribute;
import org.gcube.portlets.d4sreporting.common.shared.AttributeArea;
import org.gcube.portlets.d4sreporting.common.shared.BasicComponent;
import org.gcube.portlets.d4sreporting.common.shared.ComponentType;
import org.gcube.portlets.d4sreporting.common.shared.Metadata;
import org.gcube.portlets.d4sreporting.common.shared.RepeatableSequence;
import org.gcube.portlets.d4sreporting.common.shared.ReportReferences;
import org.gcube.portlets.d4sreporting.common.shared.Tuple;

public class ComponentBuilder {
    protected static final int COMP_WIDTH = 700;
    protected static final int COMP_HEIGHT = 35;

    protected static BasicComponent getTitle(String content, boolean isReadonly) {
        return new BasicComponent(0, 0, 700, 35, 1, ComponentType.TITLE, "", (Serializable)((Object)content), false, isReadonly, new ArrayList());
    }

    protected static BasicComponent getTextInput(String content, boolean isReadonly, Metadata ... properties) {
        ArrayList props = properties != null ? Arrays.asList(properties) : new ArrayList();
        return new BasicComponent(0, 0, 700, 35, 1, ComponentType.BODY_NOT_FORMATTED, "", (Serializable)((Object)content), false, isReadonly, props);
    }

    protected static BasicComponent getHeading(int level, String content, boolean isReadonly) {
        ComponentType type;
        switch (level) {
            case 1: {
                type = ComponentType.HEADING_1;
                break;
            }
            case 2: {
                type = ComponentType.HEADING_2;
                break;
            }
            case 3: {
                type = ComponentType.HEADING_3;
                break;
            }
            case 4: {
                type = ComponentType.HEADING_4;
                break;
            }
            case 5: {
                type = ComponentType.HEADING_5;
                break;
            }
            default: {
                throw new IllegalArgumentException("Only heading level between 1 and 5 are supported");
            }
        }
        return new BasicComponent(0, 0, 700, 35, 1, type, "", (Serializable)((Object)content), false, isReadonly, new ArrayList());
    }

    protected static BasicComponent getAttributeArea(String attrName, ArrayList<Attribute> values, boolean allowMultiselection) {
        ComponentType type = allowMultiselection ? ComponentType.ATTRIBUTE_MULTI : ComponentType.ATTRIBUTE_UNIQUE;
        return new BasicComponent(0, 0, 700, 35, 1, type, "", (Serializable)new AttributeArea(attrName, values), false, false, new ArrayList());
    }

    protected static BasicComponent getMedia() {
        return new BasicComponent(0, 0, 700, 35, 1, ComponentType.BODY_TABLE_IMAGE, "", null, false, true, new ArrayList());
    }

    protected static BasicComponent getSequenceDelimiter(int height) {
        return new BasicComponent(0, 0, 700, height, 1, ComponentType.REPEAT_SEQUENCE_DELIMITER, "", (Serializable)((Object)""), false, false, new ArrayList());
    }

    protected static BasicComponent getInstruction(String content) {
        return new BasicComponent(0, 0, 700, 35, 1, ComponentType.INSTRUCTION, "", (Serializable)((Object)content), false, false, new ArrayList());
    }

    protected static BasicComponent getReference(ReferenceReport ref) {
        ReferenceReportType refType = ref.getRefType();
        List<DBTableRow> references = ref.getReferences();
        ArrayList<Tuple> msL = new ArrayList<Tuple>();
        for (DBTableRow dBTableRow : references) {
            ArrayList<BasicComponent> groupedComponents = new ArrayList<BasicComponent>();
            groupedComponents.add(ComponentBuilder.getSequenceDelimiter(5));
            for (Metadata md : dBTableRow.getMetadata()) {
                groupedComponents.add(ComponentBuilder.getHeading(dBTableRow.getHeadingLevel(), md.getAttribute(), true));
                groupedComponents.add(ComponentBuilder.getTextInput(md.getValue(), true, new Metadata[0]));
            }
            groupedComponents.add(ComponentBuilder.getSequenceDelimiter(5));
            msL.add(new Tuple(dBTableRow.getIdentifier(), groupedComponents));
        }
        ReportReferences toEmbed = new ReportReferences(refType.toString(), msL);
        return new BasicComponent(0, 0, 700, 35, 1, ComponentType.REPORT_REFERENCE, "", (Serializable)toEmbed, false, true, new ArrayList());
    }

    protected static BasicComponent getSequence(String identifier, ReportSequence seq) {
        ArrayList<BasicComponent> groupedComponents = new ArrayList<BasicComponent>();
        groupedComponents.add(ComponentBuilder.getSequenceDelimiter(15));
        for (BasicComponent elem : seq.getSequence()) {
            groupedComponents.add(elem);
        }
        groupedComponents.add(ComponentBuilder.getSequenceDelimiter(15));
        RepeatableSequence toEmbed = new RepeatableSequence(groupedComponents, identifier, 0);
        return new BasicComponent(0, 0, 700, 35, 1, ComponentType.REPEAT_SEQUENCE, "", (Serializable)toEmbed, false, true, new ArrayList());
    }
}

