/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.reporting;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.Vector;
import org.gcube.application.reporting.ComponentBuilder;
import org.gcube.application.reporting.Modeler;
import org.gcube.application.reporting.ReportSequence;
import org.gcube.application.reporting.reference.ReferenceReport;
import org.gcube.portlets.d4sreporting.common.shared.Attribute;
import org.gcube.portlets.d4sreporting.common.shared.BasicComponent;
import org.gcube.portlets.d4sreporting.common.shared.BasicSection;
import org.gcube.portlets.d4sreporting.common.shared.ComponentType;
import org.gcube.portlets.d4sreporting.common.shared.Metadata;
import org.gcube.portlets.d4sreporting.common.shared.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReportsModeler
implements Modeler {
    private static final Logger _log = LoggerFactory.getLogger(ReportsModeler.class);
    public static final int TEMPLATE_WIDTH = 750;
    public static final int TEMPLATE_HEIGHT = 1000;
    public static final String DEFAULT_NAME = "no-name";
    private static final int MARGIN_LEFT = 0;
    private static final int MARGIN_RIGHT = 0;
    private static final int MARGIN_TOP = 0;
    private static final int MARGIN_BOTTOM = 0;
    private static final int COLUMN_WIDTH = 0;
    private int currSection = 1;
    private Model model;

    public ReportsModeler(String id, String name, String author, Date dateCreated, Date lastEdit, String lastEditorId) {
        this.model = new Model(id, author, dateCreated, lastEdit, lastEditorId, name, 0, 1, 0, 0, 0, 0, 1000, 750, new Vector(), 1, new LinkedList());
        this.initialize();
    }

    @Override
    public boolean addTitle() {
        this.addTitle("", false);
        return false;
    }

    @Override
    public boolean addTitle(String content, boolean isReadonly) {
        this.addComponentToSection(ComponentBuilder.getTitle(content, isReadonly));
        return true;
    }

    @Override
    public boolean addHeading(int level) {
        return this.addHeading(level, "", false);
    }

    @Override
    public boolean addHeading(int level, String content) {
        return this.addHeading(level, content, true);
    }

    @Override
    public boolean addHeading(int level, String content, boolean isReadonly) {
        this.addComponentToSection(ComponentBuilder.getHeading(level, content, isReadonly));
        return true;
    }

    @Override
    public boolean addTextInput(Metadata ... properties) {
        return this.addTextInput("", false, properties);
    }

    @Override
    public boolean addTextInput(String content, Metadata ... properties) {
        return this.addTextInput(content, false, properties);
    }

    @Override
    public boolean addTextInput(String content, boolean isReadonly, Metadata ... properties) {
        this.addComponentToSection(ComponentBuilder.getTextInput(content, isReadonly, properties));
        return true;
    }

    @Override
    public boolean addInstruction(String content) {
        this.addComponentToSection(ComponentBuilder.getInstruction(content));
        return true;
    }

    @Override
    public boolean addReference(ReferenceReport ref) {
        this.addComponentToSection(ComponentBuilder.getReference(ref));
        return true;
    }

    @Override
    public boolean addAttributeComponent(String attrName, ArrayList<Attribute> values, boolean allowMultiselection) {
        this.addComponentToSection(ComponentBuilder.getAttributeArea(attrName, values, allowMultiselection));
        return true;
    }

    @Override
    public boolean addSequence(String identifier, ReportSequence seq) {
        this.addComponentToSection(ComponentBuilder.getSequence(identifier, seq));
        return true;
    }

    @Override
    public boolean addMedia() {
        this.addComponentToSection(ComponentBuilder.getMedia());
        return true;
    }

    @Override
    public int nextSection() {
        ++this.currSection;
        this.model.setTotalPages(this.currSection);
        return this.model.getTotalPages();
    }

    private boolean addComponentToSection(BasicComponent bc) {
        BasicSection bs;
        if (this.model.getSections().isEmpty()) {
            bs = new BasicSection();
            this.model.getSections().add(bs);
        }
        if (this.currSection == this.model.getSections().size() + 1) {
            bs = new BasicSection();
            this.model.getSections().add(bs);
        }
        if (this.currSection == this.model.getSections().size()) {
            bs = (BasicSection)this.model.getSections().get(this.currSection - 1);
            bs.getComponents().add(bc);
            return true;
        }
        return false;
    }

    public Model getReportInstance() throws Exception {
        if (this.model.getSections().isEmpty()) {
            throw new Exception("The report is empty, has no sections.");
        }
        return this.model;
    }

    private void initialize() {
        BasicComponent bc = new BasicComponent(0, 0, 700, 35, 1, ComponentType.FAKE_TEXTAREA, "", (Serializable)((Object)""), false, false, new ArrayList());
        this.addComponentToSection(bc);
    }
}

