package org.gcube.application.reporting;

import java.util.ArrayList;
import java.util.List;

import org.gcube.application.reporting.reference.ReferenceReport;
import org.gcube.portlets.d4sreporting.common.shared.Attribute;
import org.gcube.portlets.d4sreporting.common.shared.BasicComponent;
import org.gcube.portlets.d4sreporting.common.shared.Metadata;

public class ReportSequence implements Sequentiable {

	List<BasicComponent> sequence; 
	/**
	 * 
	 */
	public ReportSequence() {
		sequence = new ArrayList<BasicComponent>();
	}

	@Override
	public boolean addHeading(int level) throws IllegalArgumentException {
		return addHeading(level, "", false);
	}

	@Override
	public boolean addHeading(int level, String content) throws IllegalArgumentException {
		return addHeading(level, content, false);
	}

	@Override
	public boolean addHeading(int level, String content, boolean isReadonly) throws IllegalArgumentException {
		sequence.add(ComponentBuilder.getHeading(level, content, isReadonly));
		return true;
	}

	@Override
	public boolean addTextInput(Metadata... properties) {
		return addTextInput("", false, properties);		
	}

	@Override
	public boolean addTextInput(String content, Metadata... properties) {
		return addTextInput("", false, properties);		
	}

	@Override
	public boolean addTextInput(String content, boolean isReadonly,	Metadata... properties) {
		sequence.add(ComponentBuilder.getTextInput(content, isReadonly, properties));
		return true;
	}

	@Override
	public boolean addAttributeComponent(String attrName, ArrayList<Attribute> values, boolean allowMultiselection) {
		sequence.add(ComponentBuilder.getAttributeArea(attrName, values, allowMultiselection));
		return true;
	}
	/**
	 *{@inheritDoc} 
	 */
	@Override
	public boolean addReference(ReferenceReport ref) {				
		sequence.add(ComponentBuilder.getReference(ref));
		return true;
	}

	public List<BasicComponent> getSequence() {
		return sequence;
	}
	
}
