/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.reporting.test;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import org.gcube.application.reporting.ReportSequence;
import org.gcube.application.reporting.ReportsModeler;
import org.gcube.application.reporting.persistence.PersistenceManager;
import org.gcube.application.reporting.reference.DBTableRow;
import org.gcube.application.reporting.reference.ReferenceReport;
import org.gcube.application.reporting.reference.ReferenceReportType;
import org.gcube.portlets.d4sreporting.common.shared.Attribute;
import org.gcube.portlets.d4sreporting.common.shared.Metadata;
import org.gcube.portlets.d4sreporting.common.shared.Model;
import org.junit.Before;
import org.junit.Test;

public class TestReportModeler {
    private static final String PATH_TO_TEST_FILE = "/Users/massi/Desktop/toDeploy/SampleVME/anyname.d4st";
    private ReportsModeler rm;

    @Before
    public void init() {
        String reportName = "Sample VME Report With RefTypes";
        String authorId = "test authorId";
        Date created = new Date();
        this.rm = new ReportsModeler(UUID.randomUUID().toString(), reportName, authorId, created, new Date(), "Massi Last Editor");
    }

    @Test
    public void createVMEDBReport() throws Exception {
        this.addSection1();
        this.rm.nextSection();
        this.addSection2();
        this.rm.nextSection();
        this.addSection3();
        PersistenceManager.writeModel((Model)this.rm.getReportInstance(), (File)new File(PATH_TO_TEST_FILE));
        System.out.println("gCube Modeler Model Instance Persisted OK ");
    }

    @Test
    public void printReportStructure() {
        PersistenceManager.readModel((String)PATH_TO_TEST_FILE);
    }

    private void addSection1() {
        this.rm.addInstruction("FAO VME TEST Input form Test Foo");
        this.rm.addTitle("FAO VME TEST Input form Foo", false);
        this.rm.addHeading(1, "VME Name (Non Editable) ");
        this.rm.addTextInput("Corner Rise Seamounts", new Metadata[0]);
        this.rm.addHeading(2, "This is a Heading of Level 2 that is editable", false);
        this.rm.addTextInput("Corner Rise Seamounts2", new Metadata[0]);
        this.rm.addHeading(3, "This is a Heading of Level 3 that is editable", false);
        this.rm.addTextInput(new Metadata[0]);
        ArrayList<Attribute> values = new ArrayList<Attribute>();
        String[] attrs = new String[]{"en", "es", "fr", "ar", "zh", "it"};
        int i = 0;
        while (i < attrs.length) {
            values.add(new Attribute(attrs[i], Boolean.valueOf(false)));
            ++i;
        }
        this.rm.addAttributeComponent("Language", values, false);
        this.rm.addInstruction("Competent authority, please insert the acronym (e.g. NAFO, CCAMLR, SEAFO)");
        this.rm.addHeading(2, "Competent Autority");
        this.rm.addTextInput("NAFO", new Metadata[0]);
        this.rm.addHeading(2, "Year");
        this.rm.addTextInput("2012", new Metadata[0]);
        this.rm.addHeading(2, "Validity Period - Start");
        this.rm.addTextInput("2008", new Metadata[0]);
        this.rm.addInstruction("End date, leave empty if not applicable");
        this.rm.addHeading(2, "Validity Period - End");
        this.rm.addTextInput(new Metadata[0]);
        this.rm.addHeading(2, "Geographic Layer");
        this.rm.addTextInput("vme_nafo_01", new Metadata[0]);
        values = new ArrayList();
        String[] areaAttributes = new String[]{"VME", "Risk area", "Benthic protected area", "Closed area", "Other type of managed area"};
        int i2 = 0;
        while (i2 < areaAttributes.length) {
            values.add(new Attribute(areaAttributes[i2], Boolean.valueOf(false)));
            ++i2;
        }
        this.rm.addAttributeComponent("Area Type", values, false);
        values = new ArrayList();
        String[] statusAttributes = new String[]{"Established", "Under establishment", "Voluntary", "Exploratory", "Potential", "Temporary"};
        int i3 = 0;
        while (i3 < statusAttributes.length) {
            values.add(new Attribute(statusAttributes[i3], Boolean.valueOf(false)));
            ++i3;
        }
        this.rm.addAttributeComponent("Status", values, false);
        this.rm.addInstruction("Continue.... ");
    }

    private void addSection2() {
        this.rm.addInstruction("A Sequence");
        ReportSequence seq = new ReportSequence();
        seq.addHeading(2, "year");
        seq.addTextInput(new Metadata[0]);
        seq.addHeading(2, "Validity Period - Start");
        seq.addTextInput(new Metadata[0]);
        seq.addHeading(2, "Validity Period - End");
        seq.addTextInput(new Metadata[0]);
        ArrayList<DBTableRow> dBTableRows = new ArrayList<DBTableRow>();
        ArrayList<Metadata> md = new ArrayList<Metadata>();
        md.add(new Metadata("Meeting Date", "2008-12-12"));
        md.add(new Metadata("Report Summary", "Aenean vulputate ac dui eu interdum. Nullam tincidunt hendrerit sollicitudin."));
        md.add(new Metadata("Committee", "Lorem ipsum dolor sit amet, consectetur adipiscing elit"));
        md.add(new Metadata("URL", "http://archive.nafo.int/open/fc/2012/fcdoc12-01.pdf"));
        md.add(new Metadata("Citation", "(Rossi et Al) adipiscing elit oekfha lfkahjf lakjfha lkfahjf alkjdfh "));
        md.add(new Metadata("Type", "The type"));
        dBTableRows.add(new DBTableRow("primaryKey", md));
        seq.addReference(new ReferenceReport(ReferenceReportType.InformationSource, dBTableRows));
        this.rm.addSequence("an id", seq);
    }

    private void addSection3() {
        this.rm.addInstruction("Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean vulputate ac dui eu interdum. Nullam tincidunt hendrerit sollicitudin. Suspendisse ac neque id libero sagittis aliquam eget nec dolor. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; ");
        this.rm.addHeading(1, "VME Specific measures");
        ArrayList<DBTableRow> dBTableRows = new ArrayList<DBTableRow>();
        ArrayList<Metadata> md = new ArrayList<Metadata>();
        md.add(new Metadata("Year", "2008"));
        md.add(new Metadata("Validity Period - Start", "2011"));
        md.add(new Metadata("Validity Period - End", "2014"));
        md.add(new Metadata("VME Specific Measure Summary", "2011 Roll over of existing measures until 31 Dec 2014. Closed to demersal fishing with possibilities of an exploratory fishing not exceed-ing 20% of the fishable area of each seamount. (CEM 2011, Art. 15)"));
        md.add(new Metadata("Link Bookmarked", "http://archive.nafo.int/open/fc/2012/fcdoc12-01.pdf"));
        md.add(new Metadata("Link Source URL", "http://archive.nafo.int/open/fc/2012/fcdoc12-01.pdf"));
        dBTableRows.add(new DBTableRow("primaryKey", md));
        md = new ArrayList();
        md.add(new Metadata("Year", "2010"));
        md.add(new Metadata("Validity Period - Start", "2012"));
        md.add(new Metadata("Validity Period - End", "2015"));
        md.add(new Metadata("VME Specific Measure Summary", "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean vulputate ac dui eu interdum. Nullam tincidunt hendrerit sollicitudin. Suspendisse ac neque id libero sagitti aliquam eget nec dolor."));
        md.add(new Metadata("Link Bookmarked", "http://archive.nafo.int/open/fc/2010/fcdoc10-01.pdf"));
        md.add(new Metadata("Link Source URL", "http://archive.nafo.int/open/fc/2010/fcdoc10-01.pdf"));
        dBTableRows.add(new DBTableRow("primaryKey", md));
        this.rm.addReference(new ReferenceReport(ReferenceReportType.GeneralMeasure, dBTableRows));
    }
}

