package org.gcube.application.reporting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.Vector;

import org.gcube.application.reporting.component.Box;
import org.gcube.application.reporting.component.BoxesArea;
import org.gcube.application.reporting.component.Heading;
import org.gcube.application.reporting.component.Instruction;
import org.gcube.application.reporting.component.TextInput;
import org.gcube.application.reporting.component.Title;
import org.gcube.application.reporting.reference.ReferenceReport;
import org.gcube.application.reporting.sequence.ReportSequence;
import org.gcube.portlets.d4sreporting.common.shared.BasicComponent;
import org.gcube.portlets.d4sreporting.common.shared.BasicSection;
import org.gcube.portlets.d4sreporting.common.shared.ComponentType;
import org.gcube.portlets.d4sreporting.common.shared.Metadata;
import org.gcube.portlets.d4sreporting.common.shared.Model;

/**
 * 
 * @author massi
 *
 */
public final class ReportsModeler implements Modeler, Sequentiable {
	/**
	 * Styling attr, not used anymore but needed for backward compatibility
	 */

	public static final String DEFAULT_NAME = "no-name";
	private static final int MARGIN_LEFT = 0;
	private static final int MARGIN_RIGHT = 0;
	private static final int MARGIN_TOP = 0;
	private static final int MARGIN_BOTTOM = 0;
	private static final int COLUMN_WIDTH = 0;


	private int currSection  = 1;
	/**
	 * model instance
	 */
	private Model model;
	/**
	 * 
	 * @param a the report unique idenntifier
	 * @param name the report name
	 * @param author the author
	 * @param dateCreated 
	 * @param lastEdit
	 * @param lastEditorId last editor username
	 */
	public ReportsModeler(String id, String name, String author, Date dateCreated, Date lastEdit, String lastEditorId) {
		model = new Model(
				id, 
				author, 
				dateCreated, 
				lastEdit, 
				lastEditorId, 
				name, 
				COLUMN_WIDTH, 
				1, // page to show
				MARGIN_BOTTOM, MARGIN_LEFT, MARGIN_RIGHT, MARGIN_TOP, TEMPLATE_HEIGHT, TEMPLATE_WIDTH, //useless params
				new Vector<BasicSection>(), 
				1, //total pages 
				new LinkedList<Metadata>());
		initialize();
	}
	/**
	 *{@inheritDoc} 
	 */
	@Override
	public boolean addTitle() {
		addTitle("", false);
		return false;
	}
	/**
	 *{@inheritDoc} 
	 */
	@Override
	public boolean addTitle(String content, boolean isReadonly) {
		Title toAdd = new Title(content, isReadonly);
		addComponentToSection(toAdd.getModelComponent());
		return true;
	}
	/**
	 *{@inheritDoc} 
	 */
	@Override
	public boolean addHeading(int level) {
		return addHeading(level, "", false);
	}
	/**
	 *{@inheritDoc} 
	 */
	@Override
	public boolean addHeading(int level, String content) {
		return addHeading(level, content, true);
	}
	/**
	 *{@inheritDoc} 
	 */
	@Override
	public boolean addHeading(int level, String content, boolean isReadonly) {		
		Heading toAdd = new Heading(level, content, isReadonly);
		addComponentToSection(toAdd.getModelComponent());
		return true;
	}

	/**
	 *{@inheritDoc} 
	 */
	@Override
	public boolean addTextInput(Property... properties) {
		return addTextInput("", false, properties);		
	}

	/**
	 *{@inheritDoc} 
	 */
	@Override
	public boolean addTextInput(String content, Property... properties) {
		return addTextInput(content, false, properties);
	}
	/**
	 *{@inheritDoc} 
	 */
	@Override
	public boolean addTextInput(String content, boolean isReadOnly, Property... properties) {
		TextInput toAdd = new TextInput(content, isReadOnly);
		toAdd.setProperties((properties != null) ? Arrays.asList(properties) : new ArrayList<Property>());
		addComponentToSection(toAdd.getModelComponent());		
		return true;
	}
	
	/**
	 *{@inheritDoc} 
	 */
	@Override
	public boolean addInstruction(String content) {			
		addComponentToSection(new Instruction(content).getModelComponent());
		return true;
	}
	/**
	 *{@inheritDoc} 
	 */
	@Override
	public boolean addReference(ReferenceReport ref) {				
		addComponentToSection(ComponentBuilder.getReference(ref));
		return true;
	}
	
	@Override
	public boolean addAttributeComponent(String attrName, ArrayList<Box> values, boolean allowMultiselection) {
		BoxesArea toAdd = new BoxesArea(attrName, values, allowMultiselection);
		addComponentToSection(toAdd.getModelComponent());
		return true;
	}
	
	@Override
	public boolean addAttributeComponent(String attrName, ArrayList<Box> values, boolean allowMultiselection, Property... properties) {
		BoxesArea toAdd = new BoxesArea(attrName, values, allowMultiselection);
		toAdd.setProperties((properties != null) ? Arrays.asList(properties) : new ArrayList<Property>());
		addComponentToSection(toAdd.getModelComponent());
		return true;
	}
	/**
	 *{@inheritDoc} 
	 */
	@Override
	public boolean addSequence(ReportSequence seq) {
		addComponentToSection(seq.getModelComponent());
		return true;
	}
	/**
	 *{@inheritDoc} 
	 */
	@Override
	public boolean addMedia() {
		addComponentToSection(ComponentBuilder.getMedia());
		return true;
	}
	/**
	 *{@inheritDoc} 
	 */
	@Override
	public int nextSection() {
		currSection++;
		model.setTotalPages(currSection);
		return model.getTotalPages();
	}
	/**
	 * 
	 * @param bc the component to add
	 */
	private boolean addComponentToSection(BasicComponent bc) {
		if (model.getSections().isEmpty()) {
			BasicSection bs = new BasicSection();
			model.getSections().add(bs);
		} 
		if (currSection == (model.getSections().size()+1)) { // check the nextSection()
			BasicSection bs = new BasicSection();
			model.getSections().add(bs);
		} 
		if (currSection == model.getSections().size()) { // current section
			BasicSection bs = model.getSections().get(currSection-1);
			bs.getComponents().add(bc);
			return true;
		}
		else
			return false;
	}

	public Model getReportInstance() throws Exception {
		if (model.getSections().isEmpty())
			throw new Exception("The report is empty, has no sections.");
		return model;
	}

	/**
	 * 
	 * add a placeholder component at the beginning of the report (for backward compatibility)
	 */
	private void initialize() {
		BasicComponent bc = new BasicComponent(0, 0, ComponentBuilder.COMP_WIDTH, ComponentBuilder.COMP_HEIGHT, 1, ComponentType.FAKE_TEXTAREA, "", "", false, false,	new ArrayList<Metadata>());		
		addComponentToSection(bc);
	}


}
