/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.reporting;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.Vector;
import org.gcube.application.reporting.ComponentBuilder;
import org.gcube.application.reporting.Modeler;
import org.gcube.application.reporting.Property;
import org.gcube.application.reporting.Sequentiable;
import org.gcube.application.reporting.component.Box;
import org.gcube.application.reporting.component.BoxesArea;
import org.gcube.application.reporting.component.Heading;
import org.gcube.application.reporting.component.Instruction;
import org.gcube.application.reporting.component.TextInput;
import org.gcube.application.reporting.component.Title;
import org.gcube.application.reporting.reference.ReferenceReport;
import org.gcube.application.reporting.sequence.ReportSequence;
import org.gcube.portlets.d4sreporting.common.shared.BasicComponent;
import org.gcube.portlets.d4sreporting.common.shared.BasicSection;
import org.gcube.portlets.d4sreporting.common.shared.ComponentType;
import org.gcube.portlets.d4sreporting.common.shared.Model;

public final class ReportsModeler
implements Modeler,
Sequentiable {
    public static final String DEFAULT_NAME = "no-name";
    private static final int MARGIN_LEFT = 0;
    private static final int MARGIN_RIGHT = 0;
    private static final int MARGIN_TOP = 0;
    private static final int MARGIN_BOTTOM = 0;
    private static final int COLUMN_WIDTH = 0;
    private int currSection = 1;
    private Model model;

    public ReportsModeler(String id, String name, String author, Date dateCreated, Date lastEdit, String lastEditorId) {
        this.model = new Model(id, author, dateCreated, lastEdit, lastEditorId, name, 0, 1, 0, 0, 0, 0, 1000, 750, new Vector(), 1, new LinkedList());
        this.initialize();
    }

    @Override
    public boolean addTitle() {
        this.addTitle("", false);
        return false;
    }

    @Override
    public boolean addTitle(String content, boolean isReadonly) {
        Title toAdd = new Title(content, isReadonly);
        this.addComponentToSection(toAdd.getModelComponent());
        return true;
    }

    @Override
    public boolean addHeading(int level) {
        return this.addHeading(level, "", false);
    }

    @Override
    public boolean addHeading(int level, String content) {
        return this.addHeading(level, content, true);
    }

    @Override
    public boolean addHeading(int level, String content, boolean isReadonly) {
        Heading toAdd = new Heading(level, content, isReadonly);
        this.addComponentToSection(toAdd.getModelComponent());
        return true;
    }

    @Override
    public boolean addTextInput(Property ... properties) {
        return this.addTextInput("", false, properties);
    }

    @Override
    public boolean addTextInput(String content, Property ... properties) {
        return this.addTextInput(content, false, properties);
    }

    @Override
    public boolean addTextInput(String content, boolean isReadOnly, Property ... properties) {
        TextInput toAdd = new TextInput(content, isReadOnly);
        toAdd.setProperties(properties != null ? Arrays.asList(properties) : new ArrayList<Property>());
        this.addComponentToSection(toAdd.getModelComponent());
        return true;
    }

    @Override
    public boolean addInstruction(String content) {
        this.addComponentToSection(new Instruction(content).getModelComponent());
        return true;
    }

    @Override
    public boolean addReference(ReferenceReport ref) {
        this.addComponentToSection(ComponentBuilder.getReference(ref));
        return true;
    }

    @Override
    public boolean addAttributeComponent(String attrName, ArrayList<Box> values, boolean allowMultiselection) {
        BoxesArea toAdd = new BoxesArea(attrName, values, allowMultiselection);
        this.addComponentToSection(toAdd.getModelComponent());
        return true;
    }

    @Override
    public boolean addAttributeComponent(String attrName, ArrayList<Box> values, boolean allowMultiselection, Property ... properties) {
        BoxesArea toAdd = new BoxesArea(attrName, values, allowMultiselection);
        toAdd.setProperties(properties != null ? Arrays.asList(properties) : new ArrayList<Property>());
        this.addComponentToSection(toAdd.getModelComponent());
        return true;
    }

    @Override
    public boolean addSequence(ReportSequence seq) {
        this.addComponentToSection(seq.getModelComponent());
        return true;
    }

    @Override
    public boolean addMedia() {
        this.addComponentToSection(ComponentBuilder.getMedia());
        return true;
    }

    @Override
    public int nextSection() {
        ++this.currSection;
        this.model.setTotalPages(this.currSection);
        return this.model.getTotalPages();
    }

    private boolean addComponentToSection(BasicComponent bc) {
        BasicSection bs;
        if (this.model.getSections().isEmpty()) {
            bs = new BasicSection();
            this.model.getSections().add(bs);
        }
        if (this.currSection == this.model.getSections().size() + 1) {
            bs = new BasicSection();
            this.model.getSections().add(bs);
        }
        if (this.currSection == this.model.getSections().size()) {
            bs = (BasicSection)this.model.getSections().get(this.currSection - 1);
            bs.getComponents().add(bc);
            return true;
        }
        return false;
    }

    public Model getReportInstance() throws Exception {
        if (this.model.getSections().isEmpty()) {
            throw new Exception("The report is empty, has no sections.");
        }
        return this.model;
    }

    private void initialize() {
        BasicComponent bc = new BasicComponent(0, 0, 700, 35, 1, ComponentType.FAKE_TEXTAREA, "", (Serializable)((Object)""), false, false, new ArrayList());
        this.addComponentToSection(bc);
    }
}

