package org.gcube.application.geoportal.common.model.profile;

import java.util.List;

import javax.json.JsonObject;

import org.gcube.application.geoportal.common.faults.JsonParseException;
import org.gcube.application.geoportal.common.model.BasicJSONObject;

import lombok.Getter;
import lombok.NoArgsConstructor;

@Getter
@NoArgsConstructor
public class Profile extends BasicJSONObject{

	
	
	public Profile(JsonObject theObject) throws JsonParseException {
		super(theObject);
		name=theObject.getString("name");
		id=theObject.getString("_id");
//		JsonArray jsonFields=theObject.getJsonArray("fields");
//		if(jsonFields==null)
//			fields=null;
//		else {
//			fields=new ArrayList<Field>();
//			for(int i= 0; i<jsonFields.size();i++)
//				fields.add(new Field(jsonFields.getJsonObject(i)));
//		}
		fields=Serialization.asArray(theObject.getJsonArray("fields"), Field.class);
		defaultCompilers=Serialization.asArray(theObject.getJsonArray("default_compilers"), DefaultCompiler.class);
		validators=Serialization.asArray(theObject.getJsonArray("validators"), Validator.class);
		isoMapper=new IsoMapper(theObject.getJsonObject("iso_mapper"));
		centroidsMapping=Serialization.asArray(theObject.getJsonArray("centroid_mapping"), FieldMapping.class);
		indexes=Serialization.asArray(theObject.getJsonArray("findexes"), IndexDefinition.class);
		
	}
	private String name;
	private String id;
	private List<Field> fields;
	
	private List<DefaultCompiler> defaultCompilers;
	private List<Validator> validators;
	private IsoMapper isoMapper;
	private List<FieldMapping> centroidsMapping;
	private List<IndexDefinition> indexes;
}
