/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.common.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Files {
    private static final Logger log = LoggerFactory.getLogger(Files.class);

    public static Map<String, List<File>> getAllShapeSet(File baseFolder, boolean recursive) throws IOException {
        return Files.clusterizeFilesByExtension(baseFolder, ".shp", recursive);
    }

    public static Map<String, List<File>> clusterizeFilesByExtension(File base, String extension, Boolean recursive) throws IOException {
        HashMap<String, List<File>> toReturn = new HashMap<String, List<File>>();
        log.debug("Clustering " + base.getAbsolutePath());
        ArrayList<File> targetFiles = new ArrayList<File>();
        if (base.isDirectory()) {
            targetFiles.addAll(Arrays.asList(base.listFiles((dir, name) -> name.endsWith(extension))));
            if (recursive.booleanValue()) {
                for (File f2 : base.listFiles((dir, name) -> new File(dir, name).isDirectory())) {
                    toReturn.putAll(Files.clusterizeFilesByExtension(f2, extension, recursive));
                }
            }
        } else {
            targetFiles.add(base);
        }
        targetFiles.forEach(f -> {
            String basename = f.getName().substring(0, f.getName().lastIndexOf("."));
            toReturn.put(f.getAbsolutePath(), Files.getSiblings(f.getParentFile(), basename));
        });
        return toReturn;
    }

    public static List<File> getSiblings(File location, String baseName) {
        ArrayList<File> fileset = new ArrayList<File>();
        for (File shpSet : location.listFiles((dir, name) -> name.startsWith(baseName))) {
            fileset.add(shpSet);
        }
        return fileset;
    }

    public static File getFileFromResources(String fileName) {
        ClassLoader classLoader = Files.class.getClassLoader();
        URL resource = classLoader.getResource(fileName);
        if (resource == null) {
            throw new IllegalArgumentException("file is not found!");
        }
        return new File(resource.getFile());
    }

    public static String readFileAsString(String path, Charset encoding) throws IOException {
        byte[] encoded = java.nio.file.Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding);
    }

    public static String getName(String path) {
        return path.substring(path.contains(File.separator) ? path.lastIndexOf(File.separator) + 1 : 0, path.contains(".") ? path.lastIndexOf(".") : path.length());
    }

    public static String fixFilename(String toFix) {
        String extension = "";
        if (toFix.contains(".")) {
            int index = toFix.indexOf(".");
            extension = toFix.substring(index);
            toFix = toFix.substring(0, toFix.indexOf("."));
        }
        return toFix.toLowerCase().replaceAll("[\\*\\+\\/\\\\ \\[\\]\\(\\)\\.\\\"\\:\\;\\|]", "_") + extension;
    }
}

