package org.gcube.application.geoportalcommon.shared.products.model;

import java.io.Serializable;
import java.util.List;

import org.gcube.application.geoportalcommon.shared.products.content.AssociatedContentDV;


/**
 * The Class AbstractRelazioneScavoDV.
 *
 * @author Francesco Mangiacrapa at ISTI-CNR (francesco.mangiacrapa@isti.cnr.it)
 * 
 * Dec 21, 2020
 */
public class AbstractRelazioneScavoDV extends AssociatedContentDV implements Serializable {


	/**
	 * 
	 */
	private static final long serialVersionUID = 8768745863185590509L;

	/** The abstract section. */
	private String abstractSectionIta;
	
	private String abstractSectionEng;

	/** The responsabili. */
	private List<String> responsabili;

	/** The soggetto. */
	private List<String> soggetto;

	/**
	 * Instantiates a new abstract relazione scavo.
	 */
	public AbstractRelazioneScavoDV() {

	}

	/**
	 * Instantiates a new abstract relazione scavo.
	 *
	 * @param abstractSectionIta the abstract section ita
	 * @param abstractSectionEng the abstract section eng
	 * @param responsabili the responsabili
	 * @param soggetto the soggetto
	 */
	public AbstractRelazioneScavoDV(String abstractSectionIta, String abstractSectionEng, List<String> responsabili, List<String> soggetto) {
		super();
		this.abstractSectionIta = abstractSectionIta;
		this.abstractSectionEng = abstractSectionEng;
		this.responsabili = responsabili;
		this.soggetto = soggetto;
	}

	/**
	 * Gets the abstract section ita.
	 *
	 * @return the abstract section ita
	 */
	public String getAbstractSectionIta() {
		return abstractSectionIta;
	}

	/**
	 * Sets the abstract section ita.
	 *
	 * @param abstractSectionIta the new abstract section ita
	 */
	public void setAbstractSectionIta(String abstractSectionIta) {
		this.abstractSectionIta = abstractSectionIta;
	}

	/**
	 * Gets the abstract section eng.
	 *
	 * @return the abstract section eng
	 */
	public String getAbstractSectionEng() {
		return abstractSectionEng;
	}

	/**
	 * Sets the abstract section eng.
	 *
	 * @param abstractSectionEng the new abstract section eng
	 */
	public void setAbstractSectionEng(String abstractSectionEng) {
		this.abstractSectionEng = abstractSectionEng;
	}

	/**
	 * Gets the responsabili.
	 *
	 * @return the responsabili
	 */
	public List<String> getResponsabili() {
		return responsabili;
	}

	/**
	 * Sets the responsabili.
	 *
	 * @param responsabili the new responsabili
	 */
	public void setResponsabili(List<String> responsabili) {
		this.responsabili = responsabili;
	}

	/**
	 * Gets the soggetto.
	 *
	 * @return the soggetto
	 */
	public List<String> getSoggetto() {
		return soggetto;
	}

	/**
	 * Sets the soggetto.
	 *
	 * @param soggetto the new soggetto
	 */
	public void setSoggetto(List<String> soggetto) {
		this.soggetto = soggetto;
	}

	/**
	 * To string.
	 *
	 * @return the string
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("RelazioneScavoDV [abstractSectionIta=");
		builder.append(abstractSectionIta);
		builder.append(", abstractSectionEng=");
		builder.append(abstractSectionEng);
		builder.append(", responsabili=");
		builder.append(responsabili);
		builder.append(", soggetto=");
		builder.append(soggetto);
		builder.append("]");
		return builder.toString();
	}



}
