package org.gcube.application.geoportalcommon.shared.products.model;

import java.io.Serializable;
import java.util.List;

import org.gcube.application.geoportalcommon.shared.products.content.AssociatedContentDV;
import org.gcube.application.geoportalcommon.shared.products.content.WorkspaceContentDV;

/**
 * The Class UploadedImage.
 *
 * @author Francesco Mangiacrapa at ISTI-CNR (francesco.mangiacrapa@isti.cnr.it)
 * 
 *         Nov 2, 2020
 */
public class UploadedImageDV extends AssociatedContentDV implements Serializable {

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = 809167060189883015L;

	/** The didascalia. */
	private String didascalia;

	/** The format. */
	private String format;

	/** The responsabili. */
	private List<String> responsabili;

	/** The soggetto. */
	private List<String> soggetto;

	private List<WorkspaceContentDV> listWsContent;

	/**
	 * Instantiates a new uploaded image.
	 */
	public UploadedImageDV() {

	}

	/**
	 * Gets the didascalia.
	 *
	 * @return the didascalia
	 */
	public String getDidascalia() {
		return didascalia;
	}

	/**
	 * Sets the didascalia.
	 *
	 * @param didascalia the new didascalia
	 */
	public void setDidascalia(String didascalia) {
		this.didascalia = didascalia;
	}

	/**
	 * Gets the format.
	 *
	 * @return the format
	 */
	public String getFormat() {
		return format;
	}

	/**
	 * Sets the format.
	 *
	 * @param format the new format
	 */
	public void setFormat(String format) {
		this.format = format;
	}

	/**
	 * Gets the responsabili.
	 *
	 * @return the responsabili
	 */
	public List<String> getResponsabili() {
		return responsabili;
	}

	/**
	 * Sets the responsabili.
	 *
	 * @param responsabili the new responsabili
	 */
	public void setResponsabili(List<String> responsabili) {
		this.responsabili = responsabili;
	}

	/**
	 * Gets the soggetto.
	 *
	 * @return the soggetto
	 */
	public List<String> getSoggetto() {
		return soggetto;
	}

	/**
	 * Sets the soggetto.
	 *
	 * @param soggetto the new soggetto
	 */
	public void setSoggetto(List<String> soggetto) {
		this.soggetto = soggetto;
	}

	public List<WorkspaceContentDV> getListWsContent() {
		return listWsContent;
	}

	public void setListWsContent(List<WorkspaceContentDV> listWsContent) {
		this.listWsContent = listWsContent;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("UploadedImageDV [didascalia=");
		builder.append(didascalia);
		builder.append(", format=");
		builder.append(format);
		builder.append(", responsabili=");
		builder.append(responsabili);
		builder.append(", soggetto=");
		builder.append(soggetto);
		builder.append(", listWsContent=");
		builder.append(listWsContent);
		builder.append("]");
		return builder.toString();
	}

}
