package org.gcube.application.geoportalcommon.shared.products.content;

import java.io.Serializable;
import java.util.Date;

import org.gcube.application.geoportalcommon.shared.products.model.RecordDV;

/**
 * The Class AssociatedContent.
 *
 * @author Francesco Mangiacrapa at ISTI-CNR (francesco.mangiacrapa@isti.cnr.it)
 * 
 * Nov 2, 2020
 */
public abstract class AssociatedContentDV implements Serializable{


	/**
	 * 
	 */
	private static final long serialVersionUID = -3666420861504055117L;

	/** The id. */
	private long id;

	/** The policy. */
	private String policy;
	
	/** The license ID. */
	private String licenseID;
	
	/** The titolo. */
	private String titolo;
	
	/** The creation time. */
	private Date creationTime;

	/** The record. */
	private RecordDV record;
	

	/**
	 * Instantiates a new associated content.
	 */
	public AssociatedContentDV() {
	}

	/**
	 * Instantiates a new associated content.
	 *
	 * @param id the id
	 * @param policy the policy
	 * @param licenseID the license ID
	 * @param titolo the titolo
	 * @param creationTime the creation time
	 * @param record the record
	 */
	public AssociatedContentDV(long id, String policy, String licenseID, String titolo, Date creationTime,
			RecordDV record) {
		super();
		this.id = id;
		this.policy = policy;
		this.licenseID = licenseID;
		this.titolo = titolo;
		this.creationTime = creationTime;
		this.record = record;
	}

	/**
	 * Gets the id.
	 *
	 * @return the id
	 */
	public long getId() {
		return id;
	}

	/**
	 * Sets the id.
	 *
	 * @param id the new id
	 */
	public void setId(long id) {
		this.id = id;
	}

	/**
	 * Gets the policy.
	 *
	 * @return the policy
	 */
	public String getPolicy() {
		return policy;
	}

	/**
	 * Sets the policy.
	 *
	 * @param policy the new policy
	 */
	public void setPolicy(String policy) {
		this.policy = policy;
	}

	/**
	 * Gets the license ID.
	 *
	 * @return the license ID
	 */
	public String getLicenseID() {
		return licenseID;
	}

	/**
	 * Sets the license ID.
	 *
	 * @param licenseID the new license ID
	 */
	public void setLicenseID(String licenseID) {
		this.licenseID = licenseID;
	}

	/**
	 * Gets the titolo.
	 *
	 * @return the titolo
	 */
	public String getTitolo() {
		return titolo;
	}

	/**
	 * Sets the titolo.
	 *
	 * @param titolo the new titolo
	 */
	public void setTitolo(String titolo) {
		this.titolo = titolo;
	}

	/**
	 * Gets the creation time.
	 *
	 * @return the creation time
	 */
	public Date getCreationTime() {
		return creationTime;
	}

	/**
	 * Sets the creation time.
	 *
	 * @param creationTime the new creation time
	 */
	public void setCreationTime(Date creationTime) {
		this.creationTime = creationTime;
	}

	/**
	 * Gets the record.
	 *
	 * @return the record
	 */
	public RecordDV getRecord() {
		return record;
	}

	/**
	 * Sets the record.
	 *
	 * @param record the new record
	 */
	public void setRecord(RecordDV record) {
		this.record = record;
	}

	/**
	 * To string.
	 *
	 * @return the string
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("AssociatedContent [id=");
		builder.append(id);
		builder.append(", policy=");
		builder.append(policy);
		builder.append(", licenseID=");
		builder.append(licenseID);
		builder.append(", titolo=");
		builder.append(titolo);
		builder.append(", creationTime=");
		builder.append(creationTime);
		builder.append(", record=");
		builder.append(record);
		builder.append("]");
		return builder.toString();
	}

}
