package org.gcube.application.geoportal.model;

import java.time.LocalDateTime;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;

import org.gcube.application.geoportal.model.report.ValidationReport;
import org.gcube.application.geoportal.model.vre.GCubeUser;
import org.gcube.application.geoportal.model.vre.SocialManager;
import org.gcube.application.geoportal.utils.Serialization;

import com.fasterxml.jackson.core.JsonProcessingException;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString
@Entity
@Inheritance(strategy = InheritanceType.TABLE_PER_CLASS)
//@Table(name = "RECORD")
//@DiscriminatorColumn(name = "RECORD_TYPE")
@EqualsAndHashCode
//@MappedSuperclass
public abstract class Record {

	//Generic Info
	@Id @GeneratedValue(strategy=GenerationType.TABLE)
	private long id;	
	
	
	protected RecordType recordType;
	protected String version="1.0.0";
	protected String licenzaID="CC-BY";
	protected AccessType accesso=AccessType.OPEN_ACCESS;
	//Nome del progetto	
	protected String nome;
	
	
	//Storage Info
	protected String folderId;
	
	//Accounting
	protected LocalDateTime lastUpdateTime=LocalDateTime.now();
	protected String lastUpdateUser;
	protected LocalDateTime creationTime=LocalDateTime.now();
	protected String creationUser;
	
	protected Record() {
		GCubeUser user=SocialManager.getCurrentUser();
		
		lastUpdateUser=user.getName();
		creationUser=user.getName();
	}
	
	public String asJson() throws JsonProcessingException {
		return Serialization.asJSON(this);
	}
	
	public ValidationReport validate() {
		ValidationReport validator=new ValidationReport("Core metadata");
		validator.checkMandatory(recordType, "Record Type");
		validator.checkMandatory(version, "Version");
		validator.checkMandatory(accesso, "Accesso ");
		validator.checkMandatory(nome, "Nome");
		validator.checkMandatory(lastUpdateTime, "Last Update Time");
		validator.checkMandatory(lastUpdateUser, "Lastu Update User");
		validator.checkMandatory(creationTime, "Creation Time");
		validator.checkMandatory(creationUser, "Creation User");
		return validator; 
	}

	
}
