/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal;

import java.beans.ConstructorProperties;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.NonNull;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.features.user.FeatureColumn;
import mil.nga.geopackage.features.user.FeatureDao;
import mil.nga.geopackage.features.user.FeatureResultSet;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.gcube.application.geoportal.model.db.DBInteractionException;
import org.gcube.application.geoportal.model.db.PostgisTable;
import org.gcube.application.geoportal.model.fault.DataParsingException;
import org.gcube.application.geoportal.model.fault.GeoPackageInteractionException;
import org.gcube.application.geoportal.storage.PostgisDBManagerI;
import org.gcube.application.geoportal.utils.CSV;
import org.gcube.application.geoportal.utils.GpkgUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgisTableFactory {
    private static final Logger log = LoggerFactory.getLogger(PostgisTableFactory.class);
    @NonNull
    private Configuration config = Configuration.DEFAULT;
    @NonNull
    private PostgisDBManagerI db;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PostgisTable fromCSV(String csvFile) throws DBInteractionException, FileNotFoundException, IOException, SQLException, DataParsingException {
        CSVParser parser = null;
        try {
            log.debug("Creating table from CSV FILE " + csvFile);
            parser = CSV.fromPath(csvFile);
            PostgisTable.GeometryType type = PostgisTable.GeometryType.POINT;
            if (csvFile.contains("linee")) {
                type = PostgisTable.GeometryType.LINE;
            } else if (csvFile.contains("poligoni")) {
                type = PostgisTable.GeometryType.POLYGON;
            }
            PostgisTable toReturn = PostgisTableFactory.fromCSVHeaders(parser.getHeaderNames(), type);
            PreparedStatement ps = this.db.prepareInsertStatement(toReturn, true, true);
            log.debug("Inserting records..");
            long count = 0L;
            for (CSVRecord r : parser.getRecords()) {
                Map map = r.toMap();
                try {
                    toReturn.fillCSVPreparedStatament(map, ps, false);
                    count += (long)ps.executeUpdate();
                }
                catch (Throwable t) {
                    log.warn("Row in error : " + map);
                    throw t;
                }
            }
            if (count != parser.getRecordNumber()) {
                throw new DBInteractionException("Incoherent number of inserted records : " + count + " / " + parser.getRecordNumber());
            }
            log.debug("Evaluating extent.. ");
            toReturn.setBoundingBox(this.db.evaluateBoundingBox(toReturn));
            PostgisTable postgisTable = toReturn;
            return postgisTable;
        }
        finally {
            if (parser != null && !parser.isClosed()) {
                parser.close();
            }
        }
    }

    public PostgisTable getExisting(String tableName) {
        throw new RuntimeException("IMPLEMENT THIS");
    }

    public PostgisTable createAs(PostgisTable source, String tableNamePrefix) throws SQLException {
        log.debug("Creating new table as " + source);
        PostgisTable toReturn = new PostgisTable(source.getTablename(), source.getFields(), source.getGeometryColumnType());
        toReturn.setTablename(tableNamePrefix + "_" + UUID.randomUUID().toString());
        this.db.create(toReturn);
        return toReturn;
    }

    public PostgisTable fromGPKGFeatureTable(GeoPackage gpkg, String featureTableName) throws SQLException, GeoPackageInteractionException, DBInteractionException, DataParsingException {
        return this.fromGPKGFeatureTable(gpkg, featureTableName, true);
    }

    public PostgisTable fromGPKGFeatureTable(GeoPackage gpkg, String featureTableName, boolean materialize) throws SQLException, GeoPackageInteractionException, DBInteractionException, DataParsingException {
        List tables = gpkg.getFeatureAndTileTables();
        if (!tables.contains(featureTableName)) {
            throw new GeoPackageInteractionException("Table " + featureTableName + " not found");
        }
        log.debug("Reading schema of " + featureTableName);
        FeatureDao featureDao = gpkg.getFeatureDao(featureTableName);
        ArrayList<String> featureColumnNames = new ArrayList<String>();
        ArrayList<PostgisTable.Field> fields = new ArrayList<PostgisTable.Field>();
        PostgisTable.GeometryType geometryType = null;
        for (FeatureColumn featCol : featureDao.getColumns()) {
            featureColumnNames.add(featCol.getName());
            String toSetFieldName = PostgisTable.sanitizeFieldName(featCol.getName());
            PostgisTable.FieldType fieldType = null;
            if (featCol.getGeometryType() != null) {
                fieldType = PostgisTable.FieldType.GEOMETRY;
                switch (featCol.getGeometryType().toString()) {
                    case "POINT": {
                        geometryType = PostgisTable.GeometryType.POINT;
                        break;
                    }
                    case "MULTIPOLYGON": {
                        geometryType = PostgisTable.GeometryType.POLYGON;
                        break;
                    }
                    case "MULTILINESTRING": {
                        geometryType = PostgisTable.GeometryType.LINE;
                        break;
                    }
                    case "MULTIPOINT": {
                        geometryType = PostgisTable.GeometryType.MULTIPOINT;
                        break;
                    }
                    default: {
                        throw new GeoPackageInteractionException("Unable to handle " + featCol.getGeometryType().toString());
                    }
                }
            } else {
                switch (featCol.getDataType()) {
                    case INT: 
                    case INTEGER: 
                    case MEDIUMINT: 
                    case SMALLINT: 
                    case TINYINT: {
                        fieldType = PostgisTable.FieldType.INT;
                        break;
                    }
                    case DOUBLE: 
                    case FLOAT: 
                    case REAL: {
                        fieldType = PostgisTable.FieldType.FLOAT;
                        break;
                    }
                    default: {
                        fieldType = PostgisTable.FieldType.TEXT;
                    }
                }
            }
            fields.add(new PostgisTable.Field(toSetFieldName, fieldType));
        }
        String toCreate = PostgisTable.sanitizeFieldName(featureTableName + "_" + UUID.randomUUID().toString());
        PostgisTable toReturn = new PostgisTable(toCreate, fields, geometryType);
        if (materialize) {
            log.debug("Creating Table..." + toCreate);
            PreparedStatement psInsert = this.db.prepareInsertStatement(toReturn, true, false);
            log.debug("Filling table " + toCreate);
            FeatureResultSet rs = (FeatureResultSet)featureDao.query();
            long count = 0L;
            while (rs.moveToNext()) {
                try {
                    Map<String, Object> row = GpkgUtils.rowAsMap(rs, fields);
                    toReturn.fillObjectsPreparedStatement(row, psInsert);
                    count += (long)psInsert.executeUpdate();
                }
                catch (Throwable t) {
                    StringBuilder rowOutput = new StringBuilder("ROW : ");
                    for (int i = 0; i < rs.getColumnCount(); ++i) {
                        rowOutput.append((String)featureColumnNames.get(i) + " : " + rs.getValue(i) + ",");
                    }
                    log.warn("Unable to insert row ", t);
                    if (log.isDebugEnabled()) {
                        log.debug("ROW was " + rowOutput);
                    }
                    if (this.config.getSkipFailingRows().booleanValue()) continue;
                    throw new GeoPackageInteractionException("Error while inserting row " + rowOutput, t);
                }
            }
            long expectedCount = featureDao.count();
            if (count != expectedCount) {
                throw new DBInteractionException("Incoherent number of inserted records : " + count + " / " + expectedCount);
            }
            log.debug("Evaluating extent.. ");
            toReturn.setBoundingBox(this.db.evaluateBoundingBox(toReturn));
        }
        return toReturn;
    }

    private static final PostgisTable fromCSVHeaders(List<String> csvHeaders, PostgisTable.GeometryType expectedType) {
        String tableName = "l" + UUID.randomUUID().toString().toLowerCase().replaceAll("-", "_");
        switch (expectedType) {
            case POINT: {
                if (!csvHeaders.contains("xcoord")) {
                    throw new RuntimeException("No xcoord in headers");
                }
                if (csvHeaders.contains("ycoord")) break;
                throw new RuntimeException("No ycoord in headers");
            }
            default: {
                if (csvHeaders.contains("wkt")) break;
                throw new RuntimeException("No wkt in headers");
            }
        }
        ArrayList<PostgisTable.Field> toSetFields = new ArrayList<PostgisTable.Field>();
        for (String csvHeader : csvHeaders) {
            String fieldName = PostgisTable.sanitizeFieldName(csvHeader);
            PostgisTable.FieldType type = PostgisTable.FieldType.TEXT;
            switch (fieldName) {
                case "xcoord": 
                case "ycoord": {
                    type = PostgisTable.FieldType.FLOAT;
                    break;
                }
                case "year": 
                case "fid": 
                case "objectid": {
                    type = PostgisTable.FieldType.INT;
                }
            }
            toSetFields.add(new PostgisTable.Field(fieldName, type));
        }
        PostgisTable.GeometryType geometryColumnType = expectedType;
        toSetFields.add(new PostgisTable.Field("geom", PostgisTable.FieldType.GEOMETRY));
        toSetFields.add(new PostgisTable.Field("internal_id", PostgisTable.FieldType.AUTOINCREMENT));
        return new PostgisTable(tableName, toSetFields, geometryColumnType);
    }

    @ConstructorProperties(value={"db"})
    public PostgisTableFactory(@NonNull PostgisDBManagerI db) {
        if (db == null) {
            throw new NullPointerException("db");
        }
        this.db = db;
    }

    public static class Configuration {
        public static final Configuration DEFAULT = new Configuration(false);
        @NonNull
        private Boolean skipFailingRows;

        @NonNull
        public Boolean getSkipFailingRows() {
            return this.skipFailingRows;
        }

        public void setSkipFailingRows(@NonNull Boolean skipFailingRows) {
            if (skipFailingRows == null) {
                throw new NullPointerException("skipFailingRows");
            }
            this.skipFailingRows = skipFailingRows;
        }

        @ConstructorProperties(value={"skipFailingRows"})
        public Configuration(@NonNull Boolean skipFailingRows) {
            if (skipFailingRows == null) {
                throw new NullPointerException("skipFailingRows");
            }
            this.skipFailingRows = skipFailingRows;
        }
    }
}

