/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.model.concessioni;

import java.util.List;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import org.gcube.application.geoportal.model.content.AssociatedContent;
import org.gcube.application.geoportal.model.report.ValidationReport;
import org.gcube.application.geoportal.utils.CollectionsUtils;

@Entity
@DiscriminatorValue(value="RELAZIONE")
public class RelazioneScavo
extends AssociatedContent {
    private String abstractSection;
    @ElementCollection(targetClass=String.class)
    private List<String> responsabili;
    @ElementCollection(targetClass=String.class)
    private List<String> soggetto;

    @Override
    public ValidationReport validateForInsertion() {
        ValidationReport toReturn = super.validateForInsertion();
        toReturn.setObjectName("Relazione Scavo");
        toReturn.checkMandatory(this.responsabili, "Responsabili");
        toReturn.checkMandatory(this.soggetto, "Soggetto");
        return toReturn;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.abstractSection == null ? 0 : this.abstractSection.hashCode());
        result = 31 * result + CollectionsUtils.hashCode(this.responsabili);
        result = 31 * result + CollectionsUtils.hashCode(this.soggetto);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RelazioneScavo other = (RelazioneScavo)obj;
        if (this.abstractSection == null ? other.abstractSection != null : !this.abstractSection.equals(other.abstractSection)) {
            return false;
        }
        if (!CollectionsUtils.equalsCollections(this.responsabili, other.responsabili)) {
            return false;
        }
        return CollectionsUtils.equalsCollections(this.soggetto, other.soggetto);
    }

    public String getAbstractSection() {
        return this.abstractSection;
    }

    public List<String> getResponsabili() {
        return this.responsabili;
    }

    public List<String> getSoggetto() {
        return this.soggetto;
    }

    public void setAbstractSection(String abstractSection) {
        this.abstractSection = abstractSection;
    }

    public void setResponsabili(List<String> responsabili) {
        this.responsabili = responsabili;
    }

    public void setSoggetto(List<String> soggetto) {
        this.soggetto = soggetto;
    }

    @Override
    public String toString() {
        return "RelazioneScavo(super=" + super.toString() + ", abstractSection=" + this.getAbstractSection() + ", responsabili=" + this.getResponsabili() + ", soggetto=" + this.getSoggetto() + ")";
    }
}

