/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.storage;

import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.gcube.application.geoportal.model.InputStreamDescriptor;
import org.gcube.application.geoportal.model.Record;
import org.gcube.application.geoportal.model.concessioni.LayerConcessione;
import org.gcube.application.geoportal.model.concessioni.RelazioneScavo;
import org.gcube.application.geoportal.model.content.AssociatedContent;
import org.gcube.application.geoportal.model.content.GeoServerContent;
import org.gcube.application.geoportal.model.content.OtherContent;
import org.gcube.application.geoportal.model.content.PersistedContent;
import org.gcube.application.geoportal.model.content.UploadedImage;
import org.gcube.application.geoportal.model.content.WorkspaceContent;
import org.gcube.application.geoportal.model.fault.PersistenceException;
import org.gcube.application.geoportal.model.gis.SDILayerDescriptor;
import org.gcube.application.geoportal.storage.SDIManager;
import org.gcube.application.geoportal.storage.WorkspaceManager;
import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentHandler {
    private static final Logger log = LoggerFactory.getLogger(ContentHandler.class);
    private Map<AssociatedContent, ArrayList<TempFile>> uploadedResources = new HashMap<AssociatedContent, ArrayList<TempFile>>();
    private Map<AssociatedContent, ArrayList<TempFile>> toDeleteResources = new HashMap<AssociatedContent, ArrayList<TempFile>>();
    private ArrayList<TempFile> toDeleteTemps = new ArrayList();
    private Record record;

    public ContentHandler(Record record) {
        this.record = record;
    }

    public void register(AssociatedContent content, InputStreamDescriptor ... iss) throws IOException {
        ArrayList<TempFile> tempFiles = new ArrayList<TempFile>();
        for (InputStreamDescriptor is : iss) {
            tempFiles.add(new TempFile(org.gcube.application.geoportal.utils.Files.copyToTemp(is.getStream()), is.getFilename()));
        }
        this.toDeleteTemps.addAll(tempFiles);
        this.uploadedResources.put(content, tempFiles);
    }

    public void unregister(AssociatedContent content, InputStreamDescriptor ... iss) {
    }

    public void dispose(AssociatedContent content) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void storeChanges(Boolean publish) throws PersistenceException {
        try {
            log.debug("Starting to persist " + this.uploadedResources.size() + " resources " + this.record.getNome());
            WorkspaceManager wsManager = new WorkspaceManager(this.record);
            SDIManager sdiManager = null;
            if (publish.booleanValue()) {
                sdiManager = new SDIManager();
            }
            for (Map.Entry<AssociatedContent, ArrayList<TempFile>> entry : this.uploadedResources.entrySet()) {
                AssociatedContent content = entry.getKey();
                ArrayList<PersistedContent> persisted = new ArrayList<PersistedContent>();
                FolderContainer destination = null;
                String description = null;
                log.debug("Storing " + content);
                if (content instanceof RelazioneScavo) {
                    destination = wsManager.getSubFolder("relazione");
                    description = "Relazione di scavo : " + content.getTitolo();
                } else if (content instanceof UploadedImage) {
                    destination = wsManager.getSubFolder("imgs");
                    description = "Immagine significativa : " + content.getTitolo();
                } else if (content instanceof SDILayerDescriptor) {
                    if (!(content instanceof LayerConcessione)) throw new Exception("Invalid SDI Content " + content);
                    destination = wsManager.getSubFolder("layers/" + content.getTitolo());
                    description = "Layer concessione : " + content.getTitolo();
                    if (publish.booleanValue()) {
                        for (TempFile theFile : entry.getValue()) {
                            GeoServerContent gsContent = sdiManager.pushLayerFile(theFile.getTheFile(), theFile.getOriginalFileName(), this.record.getId(), content.getId());
                            gsContent.setAssociated(content);
                            persisted.add(gsContent);
                        }
                    }
                } else {
                    if (!(content instanceof OtherContent)) throw new Exception("Invalid content " + content);
                    destination = wsManager.getSubFolder("other/" + content.getTitolo());
                    description = "Other content : " + content.getTitolo();
                }
                log.debug("Actually Storing files to WS folder " + destination.getId());
                for (TempFile theFile : entry.getValue()) {
                    WorkspaceContent wsContent = wsManager.storeToWS(theFile.getTheFile(), destination, theFile.getOriginalFileName(), description);
                    wsContent.setAssociated(content);
                    persisted.add(wsContent);
                }
                content.setActualContent(persisted);
            }
            return;
        }
        catch (StorageHubException e) {
            log.error("Unexpected SGHUB Exception", (Throwable)e);
            throw new PersistenceException("Unexpected Exception", e);
        }
        catch (Throwable t) {
            throw new PersistenceException("Unexpected Exception", t);
        }
    }

    protected void finalize() throws Throwable {
        for (TempFile f : this.toDeleteTemps) {
            Files.deleteIfExists(f.getTheFile().toPath());
        }
    }

    private static class TempFile {
        @NonNull
        File theFile;
        @NonNull
        String originalFileName;

        @ConstructorProperties(value={"theFile", "originalFileName"})
        public TempFile(@NonNull File theFile, @NonNull String originalFileName) {
            if (theFile == null) {
                throw new NullPointerException("theFile");
            }
            if (originalFileName == null) {
                throw new NullPointerException("originalFileName");
            }
            this.theFile = theFile;
            this.originalFileName = originalFileName;
        }

        @NonNull
        public File getTheFile() {
            return this.theFile;
        }

        @NonNull
        public String getOriginalFileName() {
            return this.originalFileName;
        }

        public void setTheFile(@NonNull File theFile) {
            if (theFile == null) {
                throw new NullPointerException("theFile");
            }
            this.theFile = theFile;
        }

        public void setOriginalFileName(@NonNull String originalFileName) {
            if (originalFileName == null) {
                throw new NullPointerException("originalFileName");
            }
            this.originalFileName = originalFileName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TempFile)) {
                return false;
            }
            TempFile other = (TempFile)o;
            if (!other.canEqual(this)) {
                return false;
            }
            File this$theFile = this.getTheFile();
            File other$theFile = other.getTheFile();
            if (this$theFile == null ? other$theFile != null : !((Object)this$theFile).equals(other$theFile)) {
                return false;
            }
            String this$originalFileName = this.getOriginalFileName();
            String other$originalFileName = other.getOriginalFileName();
            return !(this$originalFileName == null ? other$originalFileName != null : !this$originalFileName.equals(other$originalFileName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TempFile;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            File $theFile = this.getTheFile();
            result = result * 59 + ($theFile == null ? 0 : ((Object)$theFile).hashCode());
            String $originalFileName = this.getOriginalFileName();
            result = result * 59 + ($originalFileName == null ? 0 : $originalFileName.hashCode());
            return result;
        }

        public String toString() {
            return "ContentHandler.TempFile(theFile=" + this.getTheFile() + ", originalFileName=" + this.getOriginalFileName() + ")";
        }
    }
}

