package org.gcube.application.geoportal.model.report;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import lombok.Data;

@Data
public class ValidationReport implements Serializable{


	public static enum ValidationStatus{
		PASSED, ERROR, WARNING
	}


	private String objectName;


	private List<String> errorMessages=new ArrayList<String>();
	private List<String> warningMessages=new ArrayList<String>();
	private List<ValidationReport> children=new ArrayList<ValidationReport>();


	public ValidationStatus getStatus() {
		if(!errorMessages.isEmpty()) return ValidationStatus.ERROR;

		boolean isWarning=(!warningMessages.isEmpty());
		for(ValidationReport obj : children) {
			ValidationStatus status=obj.getStatus();
			if(status.equals(ValidationStatus.ERROR)) return ValidationStatus.ERROR;
			if(status.equals(ValidationStatus.WARNING)) isWarning=true;
		}
		if(isWarning) return ValidationStatus.WARNING;
		return ValidationStatus.PASSED;			
	}

	public void addChild(ValidationReport obj) {
		children.add(obj);
	}

	public void addMessage(ValidationStatus status,String message) {
		switch (status) {
		case ERROR:
			errorMessages.add(message);
			break;
		case WARNING :
			warningMessages.add(message);
		default:
			break;
		}
	}

	public boolean checkMandatory(Object toCheck,String name) {
		if(toCheck==null) {
			this.addMessage(ValidationStatus.ERROR, name+" è un campo obbligatorio.");
			return false;
		}
		if(toCheck instanceof String) {
			String toCheckString=(String) toCheck;
			if(toCheckString.isEmpty()) {
				this.addMessage(ValidationStatus.ERROR, name+" non può essere vuoto.");
				return false;	
			}
		}
		if(toCheck instanceof Collection) {
			Collection toCheckCollection=(Collection) toCheck;
			if(toCheckCollection.isEmpty()) {
				this.addMessage(ValidationStatus.ERROR, "La lista "+name+" non può essere vuoto.");
				return false;
			}


			Boolean containsError=false;
			Object[] array=toCheckCollection.toArray(new Object[toCheckCollection.size()]);
			for(int i=0;i<array.length;i++) {
				if(checkMandatory(array[i], name+ " [elemento N° "+i+"]")==false) 
					containsError=true;
			}			
			
			if(containsError) return false;

		}
		return true;
	}




	//	public boolean checkMandatoryString(String toCheck,String name) {
	//		if(toCheck==null||toCheck.isEmpty()) {
	//			this.addMessage(ValidationStatus.ERROR, name+" è un campo obbligatorio.");
	//			return false;
	//		}return true;			
	//	}	
	//	
	//	public boolean checkNonEmpty(Collection<?> toCheck, String name) {
	//		if(checkMandatory(toCheck, name)|| toCheck.isEmpty()) {
	//			this.addMessage(ValidationStatus.ERROR, name+" non può essere vuoto.");
	//			return false;
	//		}
	//		return true;
	//	}
	//	
	//	public boolean checkNonEmptyStrings(Collection<?> toCheck, String name) {
	//		if(checkNonEmpty(toCheck, name)) {
	//			Boolean internalResult=true;
	//			String[] array=toCheck.toArray(new String[toCheck.size()]);
	//			for(int i=0;i<toCheck.size();i++) {
	//				if(checkMandatoryString(array[i], name+ " [element N° "+i+"]")==false) internalResult=false;
	//			}
	//			return internalResult;
	//		}else return false;		
	//	}

	public ValidationReport(String objectName) {
		super();
		this.objectName = objectName;
	}






}
