/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.storage;

import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.application.geoportal.model.InputStreamDescriptor;
import org.gcube.application.geoportal.model.Record;
import org.gcube.application.geoportal.model.concessioni.LayerConcessione;
import org.gcube.application.geoportal.model.concessioni.RelazioneScavo;
import org.gcube.application.geoportal.model.content.AssociatedContent;
import org.gcube.application.geoportal.model.content.GeoServerContent;
import org.gcube.application.geoportal.model.content.OtherContent;
import org.gcube.application.geoportal.model.content.PersistedContent;
import org.gcube.application.geoportal.model.content.UploadedImage;
import org.gcube.application.geoportal.model.content.WorkspaceContent;
import org.gcube.application.geoportal.model.fault.PersistenceException;
import org.gcube.application.geoportal.model.gis.SDILayerDescriptor;
import org.gcube.application.geoportal.model.report.ValidationReport;
import org.gcube.application.geoportal.storage.SDIManager;
import org.gcube.application.geoportal.storage.TempFile;
import org.gcube.application.geoportal.storage.WorkspaceManager;
import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentHandler {
    private static final Logger log = LoggerFactory.getLogger(ContentHandler.class);
    private Map<AssociatedContent, ArrayList<TempFile>> uploadedResources = new HashMap<AssociatedContent, ArrayList<TempFile>>();
    private Map<AssociatedContent, ArrayList<TempFile>> toDeleteResources = new HashMap<AssociatedContent, ArrayList<TempFile>>();
    private ArrayList<TempFile> toDeleteTemps = new ArrayList();
    private Record record;

    public ContentHandler(Record record) {
        this.record = record;
    }

    public void register(AssociatedContent content, InputStreamDescriptor ... iss) throws IOException {
        ArrayList<TempFile> tempFiles = new ArrayList<TempFile>();
        for (InputStreamDescriptor is : iss) {
            tempFiles.add(new TempFile(org.gcube.application.geoportal.utils.Files.copyToTemp(is.getStream()), is.getFilename()));
        }
        this.toDeleteTemps.addAll(tempFiles);
        this.uploadedResources.put(content, tempFiles);
    }

    public void unregister(AssociatedContent content, InputStreamDescriptor ... iss) {
    }

    public void dispose(AssociatedContent content) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void storeChanges(Boolean publish) throws PersistenceException {
        try {
            log.debug("Starting to persist " + this.uploadedResources.size() + " resources " + this.record.getNome());
            WorkspaceManager wsManager = new WorkspaceManager(this.record);
            SDIManager sdiManager = null;
            if (publish.booleanValue()) {
                sdiManager = new SDIManager();
            }
            for (Map.Entry<AssociatedContent, ArrayList<TempFile>> entry : this.uploadedResources.entrySet()) {
                AssociatedContent content = entry.getKey();
                ArrayList<PersistedContent> persisted = new ArrayList<PersistedContent>();
                FolderContainer destination = null;
                String description = null;
                String workspace = null;
                log.debug("Storing " + content);
                if (content instanceof RelazioneScavo) {
                    destination = wsManager.getSubFolder("relazione");
                    description = "Relazione di scavo : " + content.getTitolo();
                } else if (content instanceof UploadedImage) {
                    destination = wsManager.getSubFolder("imgs");
                    description = "Immagine significativa : " + content.getTitolo();
                } else if (content instanceof SDILayerDescriptor) {
                    if (!(content instanceof LayerConcessione)) throw new Exception("Invalid SDI Content " + content);
                    destination = wsManager.getSubFolder("layers/" + content.getTitolo());
                    description = "Layer concessione : " + content.getTitolo();
                    if (publish.booleanValue()) {
                        if (workspace == null) {
                            workspace = sdiManager.createWorkspace("gna_conc_" + this.record.getId());
                        }
                        GeoServerContent geoserverPersisted = sdiManager.pushShapeLayerFileSet((SDILayerDescriptor)content, (List<TempFile>)entry.getValue(), workspace);
                        geoserverPersisted.setAssociated(content);
                        persisted.add(geoserverPersisted);
                    }
                } else {
                    if (!(content instanceof OtherContent)) throw new Exception("Invalid content " + content);
                    destination = wsManager.getSubFolder("other/" + content.getTitolo());
                    description = "Other content : " + content.getTitolo();
                }
                log.debug("Actually Storing files to WS folder " + destination.getId());
                for (TempFile theFile : entry.getValue()) {
                    WorkspaceContent wsContent = wsManager.storeToWS(theFile.getTheFile(), destination, theFile.getOriginalFileName(), description);
                    wsContent.setAssociated(content);
                    persisted.add(wsContent);
                }
                content.setActualContent(persisted);
            }
            return;
        }
        catch (StorageHubException e) {
            log.error("Unexpected SGHUB Exception", (Throwable)e);
            throw new PersistenceException("Unexpected Exception", e);
        }
        catch (Throwable t) {
            throw new PersistenceException("Unexpected Exception", t);
        }
    }

    protected void finalize() throws Throwable {
        for (TempFile f : this.toDeleteTemps) {
            Files.deleteIfExists(f.getTheFile().toPath());
        }
    }

    public ValidationReport validateContent() {
        return null;
    }
}

