/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.utils;

import org.gcube.application.geoportal.model.db.DatabaseConnection;
import org.gcube.common.encryption.encrypter.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;

public class ISUtils {
    public static DatabaseConnection queryForDB(String platform, String flag) {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq 'Database'").addCondition("$resource/Profile/Platform/Name/text() eq '" + platform + "'").addCondition("$resource/Profile/AccessPoint//Property[Name/text() eq 'GNA_DB'][Value/text() eq '" + flag + "']").setResult("$resource/Profile/AccessPoint");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.AccessPoint.class);
        ServiceEndpoint.AccessPoint point = (ServiceEndpoint.AccessPoint)client.submit((Query)query).get(0);
        return new DatabaseConnection(point.username(), ISUtils.decryptString(point.password()), point.address());
    }

    public static String decryptString(String toDecrypt) {
        try {
            return StringEncrypter.getEncrypter().decrypt(toDecrypt);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to decrypt : " + toDecrypt, e);
        }
    }

    public static String getgCubeBaseEndpoint(String category, String name) {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq '" + category + "'").addCondition("$resource/Profile/Name/text() eq '" + name + "'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        ServiceEndpoint.AccessPoint point = (ServiceEndpoint.AccessPoint)((ServiceEndpoint)client.submit((Query)query).get(0)).profile().accessPoints().asCollection().iterator().next();
        return point.address();
    }
}

