/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.model.concessioni;

import java.util.List;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import org.gcube.application.geoportal.model.gis.BBOX;
import org.gcube.application.geoportal.model.gis.SDILayerDescriptor;
import org.gcube.application.geoportal.model.report.Check;
import org.gcube.application.geoportal.model.report.ValidationReport;
import org.gcube.application.geoportal.utils.CollectionsUtils;

@Entity
@DiscriminatorValue(value="LAYER_CONCESSIONE")
public class LayerConcessione
extends SDILayerDescriptor {
    private String abstractSection;
    private String topicCategory;
    private String subTopic;
    private BBOX bbox;
    @ElementCollection(targetClass=String.class)
    private List<String> paroleChiaveLibere;
    @ElementCollection(targetClass=String.class)
    private List<String> paroleChiaveICCD;
    private String valutazioneQualita;
    private String metodoRaccoltaDati;
    private String scalaAcquisizione;
    @ElementCollection(targetClass=String.class)
    private List<String> authors;
    private String responsabile;

    @Override
    public ValidationReport validateForInsertion() {
        ValidationReport toReturn = super.validateForInsertion();
        toReturn.setObjectName("Layer Concessione");
        toReturn.checkMandatory(this.abstractSection, "Abstract", new Check[0]);
        toReturn.checkMandatory(this.subTopic, "Categoria (Topic)", new Check[0]);
        toReturn.checkMandatory(this.valutazioneQualita, "Valutazione della qualita", new Check[0]);
        toReturn.checkMandatory(this.metodoRaccoltaDati, "Metodo raccolta dati", new Check[0]);
        toReturn.checkMandatory(this.scalaAcquisizione, "Scala acquisizione", new Check[0]);
        toReturn.checkMandatory(this.authors, "Autori", new Check[0]);
        return toReturn;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.abstractSection == null ? 0 : this.abstractSection.hashCode());
        result = 31 * result + CollectionsUtils.hashCode(this.authors);
        result = 31 * result + (this.bbox == null ? 0 : this.bbox.hashCode());
        result = 31 * result + (this.metodoRaccoltaDati == null ? 0 : this.metodoRaccoltaDati.hashCode());
        result = 31 * result + (this.scalaAcquisizione == null ? 0 : this.scalaAcquisizione.hashCode());
        result = 31 * result + (this.subTopic == null ? 0 : this.subTopic.hashCode());
        result = 31 * result + (this.topicCategory == null ? 0 : this.topicCategory.hashCode());
        result = 31 * result + (this.valutazioneQualita == null ? 0 : this.valutazioneQualita.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LayerConcessione other = (LayerConcessione)obj;
        if (this.abstractSection == null ? other.abstractSection != null : !this.abstractSection.equals(other.abstractSection)) {
            return false;
        }
        if (!CollectionsUtils.equalsCollections(this.authors, other.authors)) {
            return false;
        }
        if (this.bbox == null ? other.bbox != null : !this.bbox.equals(other.bbox)) {
            return false;
        }
        if (this.metodoRaccoltaDati == null ? other.metodoRaccoltaDati != null : !this.metodoRaccoltaDati.equals(other.metodoRaccoltaDati)) {
            return false;
        }
        if (this.scalaAcquisizione == null ? other.scalaAcquisizione != null : !this.scalaAcquisizione.equals(other.scalaAcquisizione)) {
            return false;
        }
        if (this.subTopic == null ? other.subTopic != null : !this.subTopic.equals(other.subTopic)) {
            return false;
        }
        if (this.topicCategory == null ? other.topicCategory != null : !this.topicCategory.equals(other.topicCategory)) {
            return false;
        }
        return !(this.valutazioneQualita == null ? other.valutazioneQualita != null : !this.valutazioneQualita.equals(other.valutazioneQualita));
    }

    public String getAbstractSection() {
        return this.abstractSection;
    }

    public String getTopicCategory() {
        return this.topicCategory;
    }

    public String getSubTopic() {
        return this.subTopic;
    }

    public BBOX getBbox() {
        return this.bbox;
    }

    public List<String> getParoleChiaveLibere() {
        return this.paroleChiaveLibere;
    }

    public List<String> getParoleChiaveICCD() {
        return this.paroleChiaveICCD;
    }

    public String getValutazioneQualita() {
        return this.valutazioneQualita;
    }

    public String getMetodoRaccoltaDati() {
        return this.metodoRaccoltaDati;
    }

    public String getScalaAcquisizione() {
        return this.scalaAcquisizione;
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public String getResponsabile() {
        return this.responsabile;
    }

    public void setAbstractSection(String abstractSection) {
        this.abstractSection = abstractSection;
    }

    public void setTopicCategory(String topicCategory) {
        this.topicCategory = topicCategory;
    }

    public void setSubTopic(String subTopic) {
        this.subTopic = subTopic;
    }

    public void setBbox(BBOX bbox) {
        this.bbox = bbox;
    }

    public void setParoleChiaveLibere(List<String> paroleChiaveLibere) {
        this.paroleChiaveLibere = paroleChiaveLibere;
    }

    public void setParoleChiaveICCD(List<String> paroleChiaveICCD) {
        this.paroleChiaveICCD = paroleChiaveICCD;
    }

    public void setValutazioneQualita(String valutazioneQualita) {
        this.valutazioneQualita = valutazioneQualita;
    }

    public void setMetodoRaccoltaDati(String metodoRaccoltaDati) {
        this.metodoRaccoltaDati = metodoRaccoltaDati;
    }

    public void setScalaAcquisizione(String scalaAcquisizione) {
        this.scalaAcquisizione = scalaAcquisizione;
    }

    public void setAuthors(List<String> authors) {
        this.authors = authors;
    }

    public void setResponsabile(String responsabile) {
        this.responsabile = responsabile;
    }

    @Override
    public String toString() {
        return "LayerConcessione(super=" + super.toString() + ", abstractSection=" + this.getAbstractSection() + ", topicCategory=" + this.getTopicCategory() + ", subTopic=" + this.getSubTopic() + ", bbox=" + this.getBbox() + ", paroleChiaveLibere=" + this.getParoleChiaveLibere() + ", paroleChiaveICCD=" + this.getParoleChiaveICCD() + ", valutazioneQualita=" + this.getValutazioneQualita() + ", metodoRaccoltaDati=" + this.getMetodoRaccoltaDati() + ", scalaAcquisizione=" + this.getScalaAcquisizione() + ", authors=" + this.getAuthors() + ", responsabile=" + this.getResponsabile() + ")";
    }
}

