/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.model.content;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import org.gcube.application.geoportal.model.content.AssociatedContent;
import org.gcube.application.geoportal.model.content.GeoServerContent;
import org.gcube.application.geoportal.model.content.WorkspaceContent;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=GeoServerContent.class), @JsonSubTypes.Type(value=WorkspaceContent.class)})
public abstract class PersistedContent {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id;
    @ManyToOne
    @JoinColumn(name="content_id", nullable=false)
    private AssociatedContent associated;

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PersistedContent [id=");
        builder.append(this.id);
        if (this.associated == null) {
            builder.append(", associated=");
            builder.append(this.associated);
        } else {
            builder.append(", OWNER-associated-id=");
            builder.append(this.associated.getId());
        }
        builder.append("]");
        return builder.toString();
    }

    public long getId() {
        return this.id;
    }

    public AssociatedContent getAssociated() {
        return this.associated;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setAssociated(AssociatedContent associated) {
        this.associated = associated;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PersistedContent)) {
            return false;
        }
        PersistedContent other = (PersistedContent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        AssociatedContent this$associated = this.getAssociated();
        AssociatedContent other$associated = other.getAssociated();
        return !(this$associated == null ? other$associated != null : !this$associated.equals(other$associated));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PersistedContent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        AssociatedContent $associated = this.getAssociated();
        result = result * 59 + ($associated == null ? 0 : $associated.hashCode());
        return result;
    }
}

