package org.gcube.application.geoportal.service.engine.mongo;

import org.bson.Document;
import org.gcube.application.geoportal.common.model.profile.Profile;
import org.gcube.application.geoportal.common.model.project.Project;
import org.gcube.application.geoportal.model.fault.ConfigurationException;
import org.gcube.application.geoportal.service.engine.ImplementationProvider;

import com.mongodb.MongoClient;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;

public class MongoManager {

	private MongoClient client=null;
	
	
	
	
	public MongoManager() throws ConfigurationException {
		client=ImplementationProvider.get().getMongoClientProvider().getObject();
		
		// init profile
	}
	
	private MongoDatabase getDatabase() {
		return client.getDatabase("gna-db");
	}
	
	//*********** PROJECTS
	public void insert(Project proj, Profile profile) {		
		MongoDatabase database=getDatabase();
		// TODO check if existing DB
		
		String collectionName=profile.getName();
		
		MongoCollection<Document> collection = database.getCollection(collectionName);
		// TODO check if existing collection
		
		
		collection.insertOne(Document.parse(proj.toString()));
		
		
	}
//	public Project update(Project proj) {
//		
//	}
	
	public void delete(String id) {
		
	}
	public Document getById(String id,Profile p) {
		MongoDatabase database=getDatabase();
		MongoCollection<Document> coll=database.getCollection(p.getName());
		
		return coll.find(new Document("id",id)).first();
	}
	
	public FindIterable<Document> iterate(Document filter,Profile p) {
		MongoDatabase database=getDatabase();
		MongoCollection<Document> coll=database.getCollection(p.getName());
		
		return coll.find(filter);
	}
	
	
	//********** PROFILES
	
	
}
