package org.gcube.application.geoportal.service.rest;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;

import org.gcube.application.geoportal.common.model.project.Project;
import org.gcube.application.geoportal.common.rest.InterfaceConstants;

import lombok.extern.slf4j.Slf4j;

@Path(InterfaceConstants.Methods.PROJECTS)
@Slf4j
public class Projects {

	// GET BY ID
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("{"+InterfaceConstants.Parameters.PROJECT_ID+"}")
	public Project getByID(@PathParam(InterfaceConstants.Parameters.PROJECT_ID) String id) {
		try {
			log.info("Looking for profile [ID :{} ]",id);
			throw new RuntimeException("Feature not yet available");
		}catch(WebApplicationException e){
			log.warn("Unable to serve request",e);
			throw e;
		}catch(Throwable e){
			log.warn("Unable to serve request",e);
			throw new WebApplicationException("Unable to serve request", e);
		}
	}
	
	
	// GET ALL (Filters apply)
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	public Project getAll() {
		try {
			log.info("Loading all projects..");
			throw new RuntimeException("Feature not yet available");
		}catch(WebApplicationException e){
			log.warn("Unable to serve request",e);
			throw e;
		}catch(Throwable e){
			log.warn("Unable to serve request",e);
			throw new WebApplicationException("Unable to serve request", e);
		}
	}
	
	// Create new Project
	@PUT
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	public Project registerNew(Project toRegister) {
		try {
			log.info("Loading all projects..");
			throw new RuntimeException("Feature not yet available");
		}catch(WebApplicationException e){
			log.warn("Unable to serve request",e);
			throw e;
		}catch(Throwable e){
			log.warn("Unable to serve request",e);
			throw new WebApplicationException("Unable to serve request", e);
		}
	}
	
	
	
	
	// Modify Project Document
	
	// Delete Project
}
