/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.rest;

import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.application.geoportal.managers.ConcessioneManager;
import org.gcube.application.geoportal.managers.ManagerFactory;
import org.gcube.application.geoportal.model.InputStreamDescriptor;
import org.gcube.application.geoportal.model.Record;
import org.gcube.application.geoportal.model.concessioni.Concessione;
import org.gcube.application.geoportal.model.concessioni.LayerConcessione;
import org.gcube.application.geoportal.model.concessioni.RelazioneScavo;
import org.gcube.application.geoportal.model.content.UploadedImage;
import org.gcube.application.geoportal.model.report.PublicationReport;
import org.gcube.application.geoportal.service.engine.ImplementationProvider;
import org.gcube.application.geoportal.service.engine.StorageClientProvider;
import org.gcube.application.geoportal.service.model.internal.rest.AddSectionToConcessioneRequest;
import org.gcube.application.geoportal.service.rest.Concessioni;
import org.gcube.application.geoportal.service.utils.Serialization;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="concessioni")
public class Concessioni {
    private static final Logger log = LoggerFactory.getLogger(Concessioni.class);

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="publish/{project_id}")
    public String publish(@PathParam(value="project_id") String id) {
        try {
            log.info("Publishing Concessione by id {}\u00a0", (Object)id);
            Concessione conc = (Concessione)ConcessioneManager.getByID((long)Long.parseLong(id));
            ConcessioneManager manager = (ConcessioneManager)ManagerFactory.getByRecord((Record)conc);
            log.debug("Loaded object {}\u00a0", (Object)conc);
            PublicationReport rep = manager.commitSafely(true);
            String toReturn = rep.prettyPrint();
            log.debug("Publication report to send is " + toReturn);
            return toReturn;
        }
        catch (WebApplicationException e) {
            log.warn("Unable to serve request", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            log.warn("Unable to serve request", e);
            throw new WebApplicationException("Unable to serve request", e);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{project_id}")
    public String getById(@PathParam(value="project_id") String id) {
        try {
            log.info("Loading Concessione by id {}\u00a0", (Object)id);
            Concessione toReturn = (Concessione)ConcessioneManager.getByID((long)Long.parseLong(id));
            if (toReturn == null) {
                throw new WebApplicationException("Concessione non trovata", Response.Status.NOT_FOUND);
            }
            log.debug("Loaded object {}\u00a0", (Object)toReturn);
            return Serialization.write((Object)toReturn);
        }
        catch (WebApplicationException e) {
            log.warn("Unable to serve request", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            log.warn("Unable to serve request", e);
            throw new WebApplicationException("Unable to serve request", e);
        }
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String registerNew(String toRegister) {
        try {
            log.info("Registering new Concessione " + toRegister);
            Concessione conc = (Concessione)Serialization.read((String)toRegister, Concessione.class);
            ConcessioneManager manager = (ConcessioneManager)ManagerFactory.registerNew((Record)conc);
            manager.commitSafely(false);
            return Serialization.write((Object)manager.getRecord());
        }
        catch (WebApplicationException e) {
            log.warn("Unable to serve request", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            log.warn("Unable to serve request", e);
            throw new WebApplicationException("Unable to serve request", e);
        }
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="section/{project_id}")
    public String addSection(@PathParam(value="project_id") String id, AddSectionToConcessioneRequest request) {
        try {
            log.info("Adding section to Concessione {}\u00a0", (Object)id);
            Concessione toReturn = (Concessione)ConcessioneManager.getByID((long)Long.parseLong(id));
            ConcessioneManager manager = (ConcessioneManager)ManagerFactory.getByRecord((Record)toReturn);
            log.debug("Loaded object {}\u00a0", (Object)toReturn);
            log.debug("Request is {}", (Object)request);
            InputStreamDescriptor[] streams = new InputStreamDescriptor[request.getStreams().size()];
            StorageClientProvider storage = ImplementationProvider.get().getStorageProvider();
            for (int i = 0; i < streams.length; ++i) {
                AddSectionToConcessioneRequest.SHUBFileDescriptor sent = (AddSectionToConcessioneRequest.SHUBFileDescriptor)request.getStreams().get(i);
                streams[i] = new InputStreamDescriptor(storage.open(sent.getShubID()), sent.getFilename());
            }
            switch (1.$SwitchMap$org$gcube$application$geoportal$service$model$internal$rest$AddSectionToConcessioneRequest$Section[request.getSection().ordinal()]) {
                case 1: {
                    manager.addPiantaFineScavo((LayerConcessione)request.getToRegister(), streams);
                    break;
                }
                case 2: {
                    manager.setPosizionamento((LayerConcessione)request.getToRegister(), streams);
                    break;
                }
                case 3: {
                    manager.setRelazioneScavo((RelazioneScavo)request.getToRegister(), streams[0]);
                    break;
                }
                case 4: {
                    manager.addImmagineRappresentativa((UploadedImage)request.getToRegister(), streams[0]);
                    break;
                }
                default: {
                    throw new Exception("Unrecognized section");
                }
            }
            Concessione c = (Concessione)manager.commit(false);
            log.debug("Published " + Serialization.write((Object)c));
            return c.validate().prettyPrint();
        }
        catch (WebApplicationException e) {
            log.warn("Unable to serve request", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            log.warn("Unable to serve request", e);
            throw new WebApplicationException("Unable to serve request", e);
        }
    }

    @GET
    @Produces(value={"application/json"})
    public String getList() {
        try {
            Collection toReturn = ManagerFactory.getList(Concessione.class);
            log.debug("Found " + toReturn.size() + " elements..");
            JSONArray array = new JSONArray();
            for (Concessione found : toReturn) {
                array.put((Object)Serialization.write((Object)found));
            }
            return array.toString();
        }
        catch (WebApplicationException e) {
            log.warn("Unable to serve request", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            log.warn("Unable to serve request", e);
            throw new WebApplicationException("Unable to serve request", e);
        }
    }
}

