/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.model.internal.db;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;
import org.gcube.application.geoportal.common.model.legacy.BBOX;
import org.gcube.application.geoportal.service.model.internal.db.PostgisTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class PostgisTable {
    private static final Logger log = LoggerFactory.getLogger(PostgisTable.class);
    private static final NumberFormat DECIMAL_FORMAT = NumberFormat.getInstance(Locale.US);
    @NonNull
    private String tablename;
    @NonNull
    private List<Field> fields;
    @NonNull
    private GeometryType geometryColumnType;
    private BBOX boundingBox = null;
    private POINT centroid = null;

    public String getGeometryColumn() {
        for (Field f : this.fields) {
            if (!f.getType().equals((Object)FieldType.GEOMETRY)) continue;
            return f.getName();
        }
        return null;
    }

    public void setTablename(String tablename) {
        this.tablename = PostgisTable.sanitizeFieldName((String)tablename);
    }

    public String getCreateStatement() {
        StringBuilder stmt = new StringBuilder();
        stmt.append("CREATE TABLE IF NOT EXISTS " + this.tablename + "( ");
        for (Field field : this.fields) {
            String fieldDefinition = field.getType().getDefinition();
            if (field.getType().equals((Object)FieldType.GEOMETRY)) {
                fieldDefinition = GeometryType.access$100((GeometryType)this.getGeometryColumnType());
            }
            stmt.append(field.getName() + " " + fieldDefinition + ",");
        }
        stmt.deleteCharAt(stmt.lastIndexOf(","));
        stmt.append(")");
        return stmt.toString();
    }

    public String getDeleteByFieldStatement(Field field) {
        return "DELETE FROM " + this.tablename + " WHERE " + field.getName() + " =  ? ";
    }

    public String getInsertionStatement(boolean geometryText) {
        StringBuilder fieldList = new StringBuilder();
        StringBuilder fieldInsertion = new StringBuilder();
        block4: for (Field field : this.fields) {
            switch (1.$SwitchMap$org$gcube$application$geoportal$service$model$internal$db$PostgisTable$FieldType[field.getType().ordinal()]) {
                case 1: {
                    continue block4;
                }
                case 2: {
                    fieldList.append(field.getName() + ",");
                    if (geometryText) {
                        fieldInsertion.append("ST_GeomFromText(?, 4326),");
                        continue block4;
                    }
                    fieldInsertion.append("ST_GeomFromWKB(?, 4326),");
                    continue block4;
                }
            }
            fieldList.append(field.getName() + ",");
            fieldInsertion.append("?,");
        }
        fieldList.deleteCharAt(fieldList.lastIndexOf(","));
        fieldInsertion.deleteCharAt(fieldInsertion.lastIndexOf(","));
        return "Insert into " + this.tablename + " (" + fieldList + ") VALUES (" + fieldInsertion + ")";
    }

    public void fillObjectsPreparedStatement(Map<String, Object> row, PreparedStatement toFill) throws SQLException {
        int psFieldIndex = 0;
        HashMap<String, Object> rowValues = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : row.entrySet()) {
            rowValues.put(PostgisTable.sanitizeFieldName((String)entry.getKey()), entry.getValue());
        }
        for (Field field : this.fields) {
            if (field.getType().equals((Object)FieldType.AUTOINCREMENT)) continue;
            Object value = rowValues.get(field.getName());
            this.setObjectInPreparedStatement(field, value, toFill, ++psFieldIndex);
        }
    }

    public void setObjectInPreparedStatement(Field field, Object value, PreparedStatement toFill, int psFieldIndex) throws SQLException {
        if (value == null) {
            try {
                toFill.setNull(psFieldIndex, FieldType.access$200((FieldType)field.getType()));
            }
            catch (SQLException e) {
                log.error("Unable to set null for field " + field);
                throw e;
            }
        } else {
            switch (1.$SwitchMap$org$gcube$application$geoportal$service$model$internal$db$PostgisTable$FieldType[field.getType().ordinal()]) {
                case 3: {
                    toFill.setFloat(psFieldIndex, ((Float)value).floatValue());
                    break;
                }
                case 4: {
                    toFill.setInt(psFieldIndex, (Integer)value);
                    break;
                }
                case 5: {
                    toFill.setString(psFieldIndex, value.toString());
                    break;
                }
                case 2: {
                    toFill.setBytes(psFieldIndex, (byte[])value);
                }
            }
        }
    }

    public void fillCSVPreparedStatament(Map<String, String> row, PreparedStatement toFill, boolean explicitGeometry) throws SQLException {
        int psFieldIndex = 0;
        HashMap<String, String> rowValues = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : row.entrySet()) {
            rowValues.put(PostgisTable.sanitizeFieldName((String)entry.getKey()), entry.getValue());
        }
        for (Field field : this.fields) {
            if (field.getType().equals((Object)FieldType.AUTOINCREMENT)) continue;
            ++psFieldIndex;
            String value = (String)rowValues.get(field.getName());
            block2 : switch (1.$SwitchMap$org$gcube$application$geoportal$service$model$internal$db$PostgisTable$FieldType[field.getType().ordinal()]) {
                case 3: {
                    try {
                        toFill.setFloat(psFieldIndex, Float.parseFloat(value));
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new SQLException(field + " cannot be null.  CSV Row is " + rowValues, e);
                    }
                }
                case 4: {
                    try {
                        toFill.setInt(psFieldIndex, Integer.parseInt(value));
                    }
                    catch (NumberFormatException e) {
                        log.warn("Skipping value for " + field + " row was " + rowValues, (Throwable)e);
                        toFill.setNull(psFieldIndex, 4);
                    }
                    break;
                }
                case 5: {
                    toFill.setString(psFieldIndex, value.toString());
                    break;
                }
                case 2: {
                    if (explicitGeometry) {
                        toFill.setString(psFieldIndex, value);
                        break;
                    }
                    switch (1.$SwitchMap$org$gcube$application$geoportal$service$model$internal$db$PostgisTable$GeometryType[this.geometryColumnType.ordinal()]) {
                        case 1: {
                            String xRepresentation = DECIMAL_FORMAT.format(Double.parseDouble((String)rowValues.get("xcoord")));
                            String yRepresentation = DECIMAL_FORMAT.format(Double.parseDouble((String)rowValues.get("ycoord")));
                            toFill.setString(psFieldIndex, "POINT(" + xRepresentation + " " + yRepresentation + ")");
                            break block2;
                        }
                    }
                    toFill.setString(psFieldIndex, (String)rowValues.get("wkt"));
                }
            }
        }
    }

    public static String sanitizeFieldName(String fieldName) {
        return fieldName.toLowerCase().replaceAll("[^a-z0-9_\\\\]", "_");
    }

    public PostgisTable(@NonNull String tablename, @NonNull List<Field> fields, @NonNull GeometryType geometryColumnType) {
        if (tablename == null) {
            throw new NullPointerException("tablename is marked @NonNull but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked @NonNull but is null");
        }
        if (geometryColumnType == null) {
            throw new NullPointerException("geometryColumnType is marked @NonNull but is null");
        }
        this.tablename = tablename;
        this.fields = fields;
        this.geometryColumnType = geometryColumnType;
    }

    @NonNull
    public String getTablename() {
        return this.tablename;
    }

    @NonNull
    public List<Field> getFields() {
        return this.fields;
    }

    @NonNull
    public GeometryType getGeometryColumnType() {
        return this.geometryColumnType;
    }

    public BBOX getBoundingBox() {
        return this.boundingBox;
    }

    public POINT getCentroid() {
        return this.centroid;
    }

    public String toString() {
        return "PostgisTable(tablename=" + this.getTablename() + ", fields=" + this.getFields() + ", geometryColumnType=" + this.getGeometryColumnType() + ", boundingBox=" + this.getBoundingBox() + ", centroid=" + this.getCentroid() + ")";
    }

    public void setBoundingBox(BBOX boundingBox) {
        this.boundingBox = boundingBox;
    }

    public void setCentroid(POINT centroid) {
        this.centroid = centroid;
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static {
        ((DecimalFormat)DECIMAL_FORMAT).setGroupingUsed(false);
    }
}

