/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.rest;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GuardedMethod<T> {
    private static final Logger log = LoggerFactory.getLogger(GuardedMethod.class);
    private T result = null;

    public GuardedMethod<T> execute() throws WebApplicationException {
        try {
            this.result = this.run();
            return this;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Throwable t) {
            log.error("Unexpected error ", t);
            throw new WebApplicationException("Unexpected internal error", t, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public T getResult() {
        return (T)this.result;
    }

    protected abstract T run() throws Exception, WebApplicationException;
}

