/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import org.gcube.application.geoportal.model.Record;
import org.gcube.application.geoportal.model.concessioni.Concessione;
import org.gcube.application.geoportal.model.content.AssociatedContent;

/*
 * Exception performing whole class analysis ignored.
 */
public class Serialization {
    public static final DateTimeFormatter FULL_FORMATTER = DateTimeFormatter.ofPattern("uuuuMMdd_HH-mm-ss");
    public static ObjectMapper mapper = new ObjectMapper();

    public static <T> T read(String jsonString, Class<T> clazz) throws JsonProcessingException, IOException {
        return (T)mapper.readerFor(clazz).readValue(jsonString);
    }

    public static String write(Object toWrite) throws JsonProcessingException {
        if (toWrite instanceof Concessione) {
            Serialization.detach((Concessione)((Concessione)toWrite));
        }
        String toReturn = mapper.writeValueAsString(toWrite);
        if (toWrite instanceof Concessione) {
            Serialization.reattach((Concessione)((Concessione)toWrite));
        }
        return toReturn;
    }

    private static void detach(Concessione c) {
        if (c != null) {
            Serialization.detach((AssociatedContent)c.getRelazioneScavo());
            Serialization.detach((AssociatedContent)c.getPosizionamentoScavo());
            if (c.getPianteFineScavo() != null) {
                c.getPianteFineScavo().forEach(l -> Serialization.detach((AssociatedContent)l));
            }
            if (c.getImmaginiRappresentative() != null) {
                c.getImmaginiRappresentative().forEach(u -> Serialization.detach((AssociatedContent)u));
            }
            if (c.getGenericContent() != null) {
                c.getGenericContent().forEach(u -> Serialization.detach((AssociatedContent)u));
            }
        }
    }

    private static void detach(AssociatedContent a) {
        if (a != null) {
            a.setRecord(null);
            if (a.getActualContent() != null) {
                a.getActualContent().forEach(p -> p.setAssociated(null));
            }
        }
    }

    private static void reattach(Concessione c) {
        if (c != null) {
            Serialization.reattach((AssociatedContent)c.getRelazioneScavo(), (Record)c);
            Serialization.reattach((AssociatedContent)c.getPosizionamentoScavo(), (Record)c);
            if (c.getPianteFineScavo() != null) {
                c.getPianteFineScavo().forEach(l -> Serialization.reattach((AssociatedContent)l, (Record)c));
            }
            if (c.getImmaginiRappresentative() != null) {
                c.getImmaginiRappresentative().forEach(u -> Serialization.reattach((AssociatedContent)u, (Record)c));
            }
            if (c.getGenericContent() != null) {
                c.getGenericContent().forEach(u -> Serialization.reattach((AssociatedContent)u, (Record)c));
            }
        }
    }

    private static void reattach(AssociatedContent a, Record r) {
        if (a != null) {
            a.setRecord(r);
            if (a.getActualContent() != null) {
                a.getActualContent().forEach(p -> p.setAssociated(a));
            }
        }
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.registerModule((Module)new JavaTimeModule());
    }
}

