/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.engine.providers;

import java.beans.ConstructorProperties;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAmount;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.gcube.application.geoportal.service.engine.providers.Engine;
import org.gcube.application.geoportal.service.engine.providers.TTLObject;
import org.gcube.application.geoportal.service.model.internal.faults.ConfigurationException;
import org.gcube.application.geoportal.service.utils.ContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScopedMap<T>
implements Engine<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractScopedMap.class);
    private final Object $lock = new Object[0];
    private ConcurrentHashMap<String, TTLObject<T>> scopeMap = new ConcurrentHashMap();
    private TemporalAmount TTL = null;
    @NonNull
    private String name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getObject() throws ConfigurationException {
        Object object = this.$lock;
        synchronized (object) {
            String currentScope = ContextUtils.getCurrentScope();
            log.debug(this.name + " : obtaining object for context " + currentScope);
            this.scopeMap.putIfAbsent(currentScope, new TTLObject(LocalDateTime.now(), this.retrieveObject()));
            TTLObject found = (TTLObject)this.scopeMap.get(currentScope);
            if (this.TTL != null && !found.getCreationTime().plus(this.TTL).isBefore(LocalDateTime.now())) {
                log.debug(this.name + " : elapsed TTL, disposing..");
                this.dispose(found.getTheObject());
                found = this.scopeMap.put(currentScope, new TTLObject(LocalDateTime.now(), this.retrieveObject()));
            }
            return (T)found.getTheObject();
        }
    }

    public void shustdown() {
        log.warn(this.name + ": shutting down");
        this.scopeMap.forEach((s, o) -> {
            try {
                if (o != null && o.getTheObject() != null) {
                    this.dispose(o.getTheObject());
                }
            }
            catch (Throwable t) {
                log.warn(this.name + ": unable to dispose ", t);
            }
        });
    }

    protected abstract T retrieveObject() throws ConfigurationException;

    protected abstract void dispose(T var1);

    @ConstructorProperties(value={"name"})
    public AbstractScopedMap(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
    }

    public void setTTL(TemporalAmount TTL) {
        this.TTL = TTL;
    }
}

