package org.gcube.application.geoportal.service;

import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import org.gcube.application.geoportal.common.rest.InterfaceConstants;
import org.gcube.application.geoportal.service.rest.ConcessioniOverMongo;
import org.gcube.application.geoportal.service.rest.Profiles;
import org.gcube.application.geoportal.service.rest.Projects;
import org.gcube.application.geoportal.service.rest.Sections;
import org.gcube.application.geoportal.service.utils.Serialization;
import org.glassfish.jersey.server.ResourceConfig;

import javax.ws.rs.ApplicationPath;

@ApplicationPath(InterfaceConstants.APPLICATION_PATH)
public class GeoPortalService extends ResourceConfig{

	
	
	public GeoPortalService() {
		super();
		//Register interrfaces
//		registerClasses(Concessioni.class);
		registerClasses(ConcessioniOverMongo.class);
		registerClasses(Projects.class);
		registerClasses(Sections.class);
		registerClasses(Profiles.class);





		JacksonJaxbJsonProvider provider = new JacksonJaxbJsonProvider();
		provider.setMapper(Serialization.mapper);
		register(provider);

	}
	
	
}
